/***************************************************************************
                          wall.cpp  -  description
                             -------------------
    begin                : Mon Mar 31 2003
    copyright            : (C) 2003 by Milan Mimica
    email                : milan.mimica@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "sound.h"
#include "particle.h"
#include "wall.h"

#include "network_server.h"

#define COLLIDE_SOUND_STR std::string("collide_sound")

const ULONG Wall::ID(GEN_ID('w', 'a', 'l', 'l'));


extern float gTimeElapsed;
extern NetworkServer *gNetworkServer;


Wall::Wall(const TiXmlElement* Att, float Scale) :
	Object(Att, Scale),
	MobileObject(Att, Scale),
	PhysicalObject(Att, Scale),
	RectangleObject(Att, Scale),
	NonRotatedObject(Att, Scale) {

	CollideSound = new Sound(Parser->GetChild(Parser->GetRoot(), COLLIDE_SOUND_STR), Geo);

	IsFixedShape = true;
	AllowInaccurateCollisionDetection = true;
	PreventMultipleCollide = true;
}


Wall::~Wall() {
	delete CollideSound;
}


void Wall::OnUpdate() {
	PhysicalObject::NextFrame(gTimeElapsed);
	PhysicalObject::OnUpdate();
}


void Wall::Damage(const PhysicalObject *Obj) {
	if (Obj->GetTypeID() != Particle::ID)
		gNetworkServer->AddSound(CollideSound, true);

	PhysicalObject::Damage(Obj);
}
