/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#include "agl_text.h"
#include "text_object.h"

extern float gTimeElapsed;


TextObject::TextObject(const Point<float> &lLoc, const std::string &lText, const int &lFont, const int &lColor) :
	Loc(lLoc),
	Text(lText),
	Font(lFont),
	Color(lColor),
	FadeOutDelay(5),
	FadeOutDelayCounter(FadeOutDelay) {

	FadingOut = false;
}


TextObject::TextObject(const int &lFont) :
	Loc(0, 0),
	Font(lFont),
	FadeOutDelay(3),
	FadeOutDelayCounter(FadeOutDelay) {

	FadingOut = false;
}


void TextObject::SetText(const std::string &lText) {
	FadingOut = false;
	FadeOutDelayCounter = FadeOutDelay;
	Text = lText;
}


void TextObject::Display() {
	WriteText(Loc, Text, Font, Color);
}


void TextObject::Update() {
	if (FadingOut) {
		FadeOutDelayCounter -= gTimeElapsed;
		if (FadeOutDelayCounter > 0)
			return;

		int Alpha = geta32(Color);
		Alpha = static_cast<int>(Alpha - 255 * gTimeElapsed);

		if (Alpha <= 0) {
			FadingOut = false;
			FadeOutDelayCounter = FadeOutDelay;
			Alpha = 0;
		}

		Color = makeacol32(getr(Color), getg(Color), getb(Color), Alpha);
	}
}


#endif //SERVER_ONLY
