/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#ifndef TEXT_H
#define TEXT_H

#include "object_extension.h"

#include <string>

#define TEXT_STR std::string("text")


class Text : public ObjectExtension {
public:
	Text(const TiXmlElement *Element, const Size &Parent);

	virtual void Render(const Point<float> &Where, const float &Angle) const;
	virtual void RenderShape(BITMAP *, BITMAP *) {};
	virtual void Update() {}
	virtual bool NeedsUpdate(float TimeElapsed) {return false;}

	bool SetText(const std::string Val);
	bool SetText(const int Value);
	bool SetText(const float Value);
	bool SetText(const double Value);
	void SetVisible(const bool IsVisible) {Visible = IsVisible;}
	void SetFont(const int F) {Font = F;}
	void SetFontColor(const int c) {Color = c;}

	ULONG GetColor() const {return Color;}
	//returns number of glyphs that fits, works only for mono fonts
	USHORT GetMaxTextLen() const;
	const std::string& GetText() const {return Value;}

protected:
	std::string Value;
	bool Visible;

	int Font;
	ULONG Color;

private:
	int MaxWidth;
};

#endif

#endif //SERVER_ONLY
