/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef STATICAL_SPRITE_H
#define STATICAL_SPRITE_H

#include "agl_bitmap.h"
#include "object_extension.h"

#define STATICAL_SPRITE_STR std::string("bitmap")


class StaticalSprite : public ObjectExtension {
public:
	StaticalSprite(const TiXmlElement *Element, const Size &Parent, bool SrvMode);
	~StaticalSprite();

#ifndef SERVER_ONLY
	virtual void Render(const Point<float> &Where, const float &Angle) const;
#endif //SERVER_ONLY
	virtual void RenderShape(BITMAP *Dest, BITMAP *tmp);
	virtual void Update();
	virtual bool NeedsUpdate(float TimeElapsed);

	void SetDirection(float dir) {Direction = dir;}

	void Hide();
	void Show();

protected:
	enum DRAW_MODE {STRECHED, TILED};

	float Direction;

	bool Visible;
	bool VisibleWaiting;

	bool HasShape;
	DRAW_MODE DrawingMode;

	char Flip;

#ifndef SERVER_ONLY
	AGLBitmap *Bmp;
#endif //SERVER_ONLY
	BITMAP *ShapeBmp;
};

#endif
