/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "statical_sprite.h"
#include "bitmap_server.h"

#define DIRECTION_STR std::string("direction")
#define SOURCE_STR std::string("source")
#define IS_SHAPE_STR std::string("is_shape")
#define DRAWING_MODE_STR std::string("drawing_mode")

#define FLIP_STR std::string("flip")

//255 / 2PI
#define ANGLE_FACTOR 40.5845105f

#define VER 1
#define HOR 2
#define NONE 3


extern BitmapServer *gBmpSrv;


StaticalSprite::StaticalSprite(const TiXmlElement *Element, const Size &Parent, bool SrvMode) :
	ObjectExtension(Element, Parent, SrvMode),
	Visible(false),
	VisibleWaiting(true) {

	HasShape = (bool)XMLParser::GetValueL(Element, IS_SHAPE_STR, 0);
	DrawingMode = (DRAW_MODE)XMLParser::GetValueL(Element, DRAWING_MODE_STR, STRECHED);
	Direction = XMLParser::GetValueF(Element, DIRECTION_STR, 0.f);

#ifndef SERVER_ONLY
	if (!ServerMode)
		Bmp = new AGLBitmap(XMLParser::GetValueS(Element, SOURCE_STR, "none"));
	else
#endif //SERVER_ONLY
		if (HasShape)
			ShapeBmp = gBmpSrv->GetBitmap16(XMLParser::GetValueS(Element, SOURCE_STR, "none"));

	const std::string strFlip = XMLParser::GetValueS(Element, FLIP_STR, "");

	Flip = NONE;

	if (!strFlip.empty()) {
		if (strFlip[0] == 'h' || strFlip[0] == 'H') {
#ifndef SERVER_ONLY
			if (!ServerMode)
				Bmp->HFlip();
			else
#endif //SERVER_ONLY
				Flip = HOR;
		}

		if (strFlip[0] == 'v' || strFlip[0] == 'V') {
#ifndef SERVER_ONLY
			if (!ServerMode)
				Bmp->VFlip();
			else
#endif //SERVER_ONLY
				Flip = VER;
		}
	}
}


StaticalSprite::~StaticalSprite() {
#ifndef SERVER_ONLY
	if (!ServerMode)
		delete Bmp;
#endif //SERVER_ONLY
}


#ifndef SERVER_ONLY
void StaticalSprite::Render(const Point<float> &Where, const float &Angle) const {
	if (!Visible)
		return;

	const Rect<float> Src(0, 0, Bmp->Dim.Width, Bmp->Dim.Height);
	const Rect<float> Dst(Where + static_cast<Point<float> >(Geo), Geo);
	if (DrawingMode == STRECHED)
		Bmp->Render(Src, Dst, Direction + Angle);
	else //TILED
		Bmp->Tile(Src, Dst);
}
#endif //SERVER_ONLY


void StaticalSprite::RenderShape(BITMAP *Dest, BITMAP *tmp) {
	if (!HasShape || !Visible)
		return;

	if (DrawingMode == STRECHED) {
		if (Direction) {
			if (Flip == NONE) {
				stretch_sprite(tmp, ShapeBmp, 0, 0, Geo.Width, Geo.Height);
				rotate_sprite(Dest, tmp, (int)Geo.x, (int)Geo.y, ftofix(Direction * ANGLE_FACTOR));
			}
			else if (Flip == HOR) {
				rotate_scaled_sprite(tmp, ShapeBmp, 0, 0,
					ftofix(Direction * ANGLE_FACTOR),
					ftofix(ShapeBmp->h / (float)Geo.Height));
				draw_sprite_h_flip(Dest, tmp, (int)Geo.x, (int)Geo.y);
			}
			else if (Flip == VER) {
				rotate_scaled_sprite(tmp, ShapeBmp, 0, 0,
					ftofix(Direction * ANGLE_FACTOR),
					ftofix(ShapeBmp->h / (float)Geo.Height));
				draw_sprite_v_flip(Dest, tmp, (int)Geo.x, (int)Geo.y);
			}
		}
		else {
			if (Flip == HOR) {
				stretch_sprite(tmp, ShapeBmp, 0, 0, Geo.Width, Geo.Height);
				draw_sprite_h_flip(Dest, tmp, (int)Geo.x, (int)Geo.y);
			}
			else if (Flip == VER) {
				stretch_sprite(tmp, ShapeBmp, 0, 0, Geo.Width, Geo.Height);
				draw_sprite_v_flip(Dest, tmp, (int)Geo.x, (int)Geo.y);
			}
			else
				stretch_sprite(Dest, ShapeBmp, 0, 0, Geo.Width, Geo.Height);
		}
	}
	else if  (DrawingMode == TILED)
		clear_bitmap(Dest);
}


void StaticalSprite::Update() {
	Visible = VisibleWaiting;
}


bool StaticalSprite::NeedsUpdate(float) {
	return Visible != VisibleWaiting;
}


void StaticalSprite::Hide() {
	VisibleWaiting = false;
}


void StaticalSprite::Show() {
	VisibleWaiting = true;
}

