/***************************************************************************
                          sprite.h  -  description
                             -------------------
    begin                : Sat Mar 22 2003
    copyright            : (C) 2003 by Milan Mimica
    email                : milan.mimica@gmail.com   
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SPRITE_H
#define SPRITE_H

#include "agl_bitmap.h"
#include "object_extension.h"

#ifdef SERVER_ONLY
#include <allegro.h>
#endif //SERVER_ONLY

#define SPRITE_STR std::string("sprite")


class Sprite : public ObjectExtension {
public:
	Sprite(const TiXmlElement *Element, const Size &Parent, bool SrvMode);
	~Sprite();

#ifndef SERVER_ONLY
	virtual void Render(const Point<float> &Where, const float &Angle) const;
#endif //SERVER_ONLY
	virtual void RenderShape(BITMAP *Dest, BITMAP *tmp);
	virtual void Update();
	virtual bool NeedsUpdate(float TimeElapsed);

	void SetSize(Size NewValue) {Geo = NewValue;}
	void SetLoc(Point<float> NewValue) {Geo = NewValue;}
	void SetDirection(float NewValue) {DirectionWaiting = NewValue;}
	void SetFPS(float n) {FPSWaiting = n;}

	//controling methods
	void Stop(); //stops the animation, makes it invisible, it's possible to continue it
	void Pause(); //stops the animation, leaves the active frame visible, it's possbile to continue it
	void Play(); //continues the animation forward, makes it visible
	void PlayReversed(); //continues the animation backward, makes it visible
	void PlayOnce();
	void PlayOnceReversed();
	void JumpToEnd(); //jups to the last frame
	void JumpToStart(); //jumps to the first frame
	void JumpToFrame(USHORT Number); //The first frame number is 0, the last one is GetFrameCount()-1

	bool IsOver() const {return Over;} //returns true if the actual frame is the last one, or the animation is repeating
	bool IsPlaying() const {return Playing;} //returns true if playing, false if stopped or paused

	void SetTintColor(const int &Color) {TintColor = Color;}

	USHORT GetCurrentFrame() const {return ActiveWaiting;}
	inline USHORT GetFrameCount() const {
#ifndef SERVER_ONLY
		return ServerMode ? ShapeBmp->w / ShapeBmp->h : Bmp->Dim.Width / Bmp->Dim.Height;
#endif //SERVER_ONLY
		return ShapeBmp->w / ShapeBmp->h;
	}
	float GetFPS() const {return FPSWaiting;}
	Point<float> GetLoc() const {return Geo;}
	USHORT GetWidth() const {return Geo.Width;}
	USHORT GetHeight() const {return Geo.Height;}

private:
	float FPS;
	float Direction;
	float SecSkipped;
	bool HasShape;

	short int Active;
	bool Visible;
	bool Over;
	bool PlayingOnce;
	bool Reversed;
	bool Playing;

	bool VisibleWaiting;
	short int ActiveWaiting;
	float DirectionWaiting;
	float FPSWaiting;

	int TintColor;

	char Flip;

#ifndef SERVER_ONLY
	AGLBitmap *Bmp;
#endif //SERVER_ONLY
	BITMAP *ShapeBmp;
};


#endif
