/***************************************************************************
                          sprite.cpp  -  description
                             -------------------
    begin                : Fri Feb 28 2003
    copyright            : (C) 2003 by Milan Mimica
    email                : milan.mimica@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "sprite.h"

#include "sparklet_utils.h"
#include "bitmap_server.h"

#define DIRECTION_STR std::string("direction")

#define FLIP_STR std::string("flip")

#define SOURCE_STR std::string("source")
#define FPS_STR std::string("fps")
#define TINT_COLOR_STR std::string("tint_color")
#define IS_SHAPE_STR std::string("is_shape")

//255 / 2PI
#define ANGLE_FACTOR 40.5845105f

#define VER 1
#define HOR 2
#define NONE 3

extern BitmapServer *gBmpSrv;


Sprite::Sprite(const TiXmlElement *Element, const Size &Parent, bool SrvMode) :
	ObjectExtension(Element, Parent, SrvMode),
	Active(-1),
	Visible(true),
	Over(false),
	PlayingOnce(false),
	Reversed(false),
	Playing(true),
	VisibleWaiting(true),
	ActiveWaiting(0) {

	HasShape = (bool)XMLParser::GetValueL(Element, IS_SHAPE_STR, 0);
	FPS = XMLParser::GetValueF(Element, FPS_STR, 0.01f);
	TintColor = (unsigned long)XMLParser::GetValueL(Element, TINT_COLOR_STR, 0xffffffff);
	Direction = XMLParser::GetValueF(Element, DIRECTION_STR, 0.f);

	DirectionWaiting = Direction;
	FPSWaiting = FPS;

#ifndef SERVER_ONLY
	if (!ServerMode)
		Bmp = new AGLBitmap(XMLParser::GetValueS(Element, SOURCE_STR, "none"));
	else
#endif //SERVER_ONLY
		ShapeBmp = gBmpSrv->GetBitmap16(XMLParser::GetValueS(Element, SOURCE_STR, "none"));

	const std::string strFlip = XMLParser::GetValueS(Element, FLIP_STR, "");

	Flip = NONE;

	if (!strFlip.empty()) {
		if (strFlip[0] == 'h' || strFlip[0] == 'H') {
#ifndef SERVER_ONLY
			if (!ServerMode)
				Bmp->HFlip();
			else
#endif //SERVER_ONLY
				Flip = HOR;
		}

		if (strFlip[0] == 'v' || strFlip[0] == 'V') {
#ifndef SERVER_ONLY
			if (!ServerMode)
				Bmp->VFlip();
			else
#endif //SERVER_ONLY
				Flip = VER;
		}
	}

	SecSkipped = 0;
}


Sprite::~Sprite() {
#ifndef SERVER_ONLY
	if (!ServerMode)
		delete Bmp;
#endif //SERVER_ONLY
}


#ifndef SERVER_ONLY
void Sprite::Render(const Point<float> &Where, const float &Angle) const {
	if (Active < 0) {
		_ERROR_;
		return;
	}

	if (Visible == false)
		return;

	const Rect<float> Src(Active * Bmp->Dim.Height, 0, Bmp->Dim.Height, Bmp->Dim.Height);

	glColor4ub(getr32(TintColor), getg32(TintColor), getb32(TintColor), geta32(TintColor));
	Bmp->Render(Src, Rect<float>(Where + static_cast<Point<float> >(Geo), Geo), Direction + Angle);
	glColor4ub(255, 255, 255, 255);
}
#endif //SERVER_ONLY


void Sprite::RenderShape(BITMAP *Dest, BITMAP *tmp) {
	if (!HasShape || !Visible)
		return;

	if (Active < 0) {
		_ERROR_;
		return;
	}

	if (Direction) {
		if (Flip == NONE) {
			masked_stretch_blit(ShapeBmp, tmp, Active * ShapeBmp->h, 0, ShapeBmp->h, ShapeBmp->h, 0, 0, Geo.Width, Geo.Height);
			rotate_sprite(Dest, tmp, (int)Geo.x, (int)Geo.y, ftofix(Direction * ANGLE_FACTOR));
		}
		else if (Flip == HOR) {
			rotate_scaled_sprite(tmp, ShapeBmp, Active * ShapeBmp->h, 0,
				ftofix(Direction * ANGLE_FACTOR),
				ftofix(ShapeBmp->h / (float)Geo.Height));
			//something is obviously wrong with sparklet's fliping
			draw_sprite_v_flip(Dest, tmp, (int)Geo.x, (int)Geo.y);
		}
		else if (Flip == VER) {
			rotate_scaled_sprite(tmp, ShapeBmp, Active * ShapeBmp->h, 0,
				ftofix(Direction * ANGLE_FACTOR),
				ftofix(ShapeBmp->h / (float)Geo.Height));
			//something is obviously wrong with sparklet's fliping
			draw_sprite_h_flip(Dest, tmp, (int)Geo.x, (int)Geo.y);
		}
	}
	else {
		if (Flip == HOR) {
			masked_stretch_blit(ShapeBmp, tmp, Active * ShapeBmp->h, 0, ShapeBmp->h, ShapeBmp->h, 0, 0, Geo.Width, Geo.Height);
			//something is obviously wrong with sparklet's fliping
			draw_sprite_v_flip(Dest, tmp, (int)Geo.x, (int)Geo.y);
		}
		else if (Flip == VER) {
			masked_stretch_blit(ShapeBmp, tmp, Active * ShapeBmp->h, 0, ShapeBmp->h, ShapeBmp->h, 0, 0, Geo.Width, Geo.Height);
			//something is obviously wrong with sparklet's fliping
			draw_sprite_h_flip(Dest, tmp, (int)Geo.x, (int)Geo.y);
		}
		else
			masked_stretch_blit(ShapeBmp, Dest, Active * ShapeBmp->h, 0, ShapeBmp->h, ShapeBmp->h, 0, 0, Geo.Width, Geo.Height);
	}
}


void Sprite::Update() {
	if (SecSkipped >= 1 / FPS) {
		if (Reversed == false) {
			Active += (USHORT)(SecSkipped / (1 / FPS));
			Over = Active >= GetFrameCount() - 1;

			if ((Active >= GetFrameCount() - 1) && PlayingOnce) {
				Playing = false;
				Active = GetFrameCount() - 1;
			}

			Active %= GetFrameCount();
		}
		else {
			Active -= (USHORT)(SecSkipped / (1 / FPS));
			if (Active < 0) {
				Over = true;
				Playing = !PlayingOnce;

				if (PlayingOnce)
					Active = 0;
				else
					Active = abs(Active) + Active + GetFrameCount();
			}
			Active %= GetFrameCount();
		}

		SecSkipped = fmod(SecSkipped, 1 / FPS);
		ActiveWaiting = Active;
	}
	else {
		Active = ActiveWaiting;
	}

	Visible = VisibleWaiting;
	Direction = DirectionWaiting;
	FPS = FPSWaiting;
}


bool Sprite::NeedsUpdate(float TimeElapsed) {
	if (VisibleWaiting != Visible || ActiveWaiting != Active
		|| DirectionWaiting != Direction || FPS != FPSWaiting)
			return true;

	if (Playing == true) {
		SecSkipped += TimeElapsed;
		if (SecSkipped >= 1 / FPS) {
			return true;
		}
	}

	return false;
}


void Sprite::Stop() {
	Playing = false;
	VisibleWaiting = false;
	Over = false;
}


void Sprite::Pause() {
	Playing = false;
	Over = false;
}


void Sprite::Play() {
	Playing = true;
	Reversed = false;
	VisibleWaiting = true;
	Over = false;
	PlayingOnce = false;
}


void Sprite::PlayReversed() {
	Reversed = true;
	Playing = true;
	VisibleWaiting = true;
	Over = false;
	PlayingOnce = false;
}


void Sprite::PlayOnce() {
	Play();
	PlayingOnce = true;
}


void Sprite::PlayOnceReversed() {
	PlayReversed();
	PlayingOnce = true;
}


void Sprite::JumpToStart() {
	ActiveWaiting = 0;
	SecSkipped = 0;
	Over = false;
}


void Sprite::JumpToEnd() {
	ActiveWaiting = GetFrameCount() - 1;
	SecSkipped = 0;
	Over = false;
}


void Sprite::JumpToFrame(USHORT Number) {
	ActiveWaiting = Number;
	SecSkipped = 0;
	Over = false;
}
