/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef SPAWN_PLACE_H
#define SPAWN_PLACE_H

#include "floating_object.h"
#include "initializer.h"


#define SPAWN_PLACE_STR std::string("spawn_place")


class SpawnPlace : public FloatingObject {
public:
	SpawnPlace(const TiXmlElement *Att, float Scale);

	virtual void OnUpdate();
	virtual void Unlink();
	virtual const ULONG GetTypeID() const {return GEN_ID('s', 'p', 'p', 'l');}

	virtual void OnOver(PlayerObject* PlaObj);

	void Spawn(Object* Newborn);
	bool IsFree() {return Free;}

private:
	bool Free;
	USHORT TimeToFree;
};

DECLARE_FACTORY(SpawnPlace, Object)

#endif
