/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef WIN32
#include <allegro.h>
#include <winalleg.h>
#endif


#include "spawn_place.h"

#include "game_logic.h"


extern GameLogic *gGameLogic;


SpawnPlace::SpawnPlace(const TiXmlElement *Att, float Scale) :
	Object(Att, Scale),
	FloatingObject(Att, Scale) {

	Free = true;
	TimeToFree = 50;

	gGameLogic->AddSpawnPlace(this);
}


void SpawnPlace::Spawn(Object *Newborn) {
	Free = false;
	Newborn->SetLocC(Point<float>(Geo.x + Geo.Width / 2, Geo.y + Geo.Height / 2));
}


void SpawnPlace::OnUpdate() {
	if (Free == false)
		--TimeToFree;
	else
		TimeToFree = 0;

	if (TimeToFree == 0) {
		TimeToFree = 50;
		Free = true;
	}

	FloatingObject::OnUpdate();
}


void SpawnPlace::OnOver(PlayerObject *) {
	Free = false;
}


void SpawnPlace::Unlink() {
	gGameLogic->RemoveSpawnPlace(this);
	FloatingObject::Unlink();
}
