/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "sprite.h"
#include "smoke.h"
#include "game_logic.h"

#define DURATION_STR std::string("duration")
#define IMPULSE_STR std::string("impulse")


extern float gTimeElapsed;


const ULONG Smoke::ID(GEN_ID('s', 'm', 'o', 'k'));


Smoke::Smoke(const TiXmlElement* Att, float Scale) :
	Object(Att, Scale),
	MobileObject(Att, Scale) {

	const TiXmlElement *Root = Parser->GetRoot();

	BaseSprite = GetBaseSprite(Root);
	BaseSprite->PlayOnce();

	float Duration = XMLParser::GetValueF(Root, DURATION_STR, 1.f);
	Duration = XMLParser::GetValueF(Att, DURATION_STR, Duration);

	const std::string RandImpulse = XMLParser::GetValueS(Att, IMPULSE_STR, "");
	const int Value = 15;
	if (RandImpulse == "rnd") {
		if (rand() % 2)
			Impulse.x = -(Value + rand() % Value);
		else
			Impulse.x = Value + rand() % Value;

		if (rand() % 2)
			Impulse.y = -(Value + rand() % Value);
		else
			Impulse.y = Value + rand() % Value;
	}

	BaseSprite->SetFPS(BaseSprite->GetFrameCount() / Duration);
}


void Smoke::OnUpdate() {
	Velocity += Impulse / Mass;
	Geo += Velocity * gTimeElapsed;

	if (Extension[0]->NeedsUpdate(gTimeElapsed))
		Extension[0]->Update();

	MobileObject::OnUpdate();

	if (BaseSprite->IsOver())
		Unlink();
}
