/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#include "ship_selector.h"
#include "structures.h"
#include "xmlparser.h"
#include <string>
#include <algorithm>


ShipSelector::ShipSelector() {
	iThumb.Shape(0, 0, 155, 155);
	iThumb.ClearFlag(D_AUTOSIZE);

	bPrevious.Shape(10, 155, 60, 20);
	bPrevious.SetText("Previous");
	bNext.Shape(85, 155, 60, 20);
	bNext.SetText("Next");

	lName.Shape(180, 0, 200, 20);

	lDesc.Shape(180, 30, 240, 100);
	lDesc.SetWordWrap(true);

	GetShipFiles();
	ParseShipFiles();

	CurrentShip = get_config_int("client", "ship_index", 0);
	SelectCurrentShip();

	Add(bPrevious);
	Add(bNext);
	Add(iThumb);
	Add(lName);
	Add(lDesc);
}


ShipSelector::~ShipSelector() {
	for (USHORT i = 0; i < ShipInfoList.size(); ++i)
		delete ShipInfoList[i];
}


std::string ShipSelector::GetShipPath() {
	const std::string FullPath = ShipInfoList[CurrentShip]->Path;
	int length = strlen(FullPath.c_str());
	char *_RelPath = (char*)malloc(length);
	const std::string RelPath(make_relative_filename(_RelPath, DATA_PREFIX, FullPath.c_str(), length));
	free(_RelPath);
	return RelPath;
}


void ShipSelector::SaveSettings() {
	set_config_int("client", "ship_index", CurrentShip);
}


int GetShipsHelper(const char *filename, int attrib, void *ShipInfoList) {
	if (attrib & FA_DIREC)
		return 0;

	if (strstr(filename + strlen(filename) - 6, "_w.nso"))
		static_cast<std::vector<ShipSelector::ShipInfo*>* >(ShipInfoList)->push_back(
			new ShipSelector::ShipInfo(filename));

	return 0;
}


void ShipSelector::GetShipFiles() {
	const std::string SharedPath = std::string(DATA_PREFIX) + "defs/objects/vehicles/" + "*";
	for_each_file_ex(SharedPath.c_str(), 0, 0, GetShipsHelper, &ShipInfoList);
	_SPARKLET_ASSERT(ShipInfoList.size());
}


void ShipSelector::ParseShipFiles() {
	for (USHORT i = 0; i < ShipInfoList.size(); ++i) {
		ShipInfo *const VI = ShipInfoList[i];
		XMLParser Parser(VI->Path);
		const TiXmlElement *const XMLRoot = Parser.GetRoot();

		VI->Name = XMLParser::GetValueS(XMLRoot, "name", "");
		VI->Description = XMLParser::GetValueS(XMLRoot, "desc", "");
		VI->ThumbPath = XMLParser::GetValueS(XMLRoot, "thumb", "");
	}
}


void ShipSelector::HandleEvent(Widget &obj, int msg, int arg1, int arg2) {
	Dialog::HandleEvent(obj, msg, arg1, arg2);

	switch (msg) {
		case MSG_ACTIVATE:
			if (obj == bPrevious)
				++CurrentShip;
			else if (obj == bNext)
				--CurrentShip;

			if (CurrentShip < 0)
				CurrentShip = ShipInfoList.size() - 1;
			else if ((USHORT)CurrentShip >= ShipInfoList.size())
				CurrentShip = 0;

			SelectCurrentShip();
		break;
	}
}


void ShipSelector::SelectCurrentShip() {
	lDesc.SetText(ShipInfoList[CurrentShip]->Description.c_str());
	lName.SetText(ShipInfoList[CurrentShip]->Name.c_str());
	Dialog::GetParent()->Redraw();

	iThumb.SetBitmap((DATA_PREFIX + ShipInfoList[CurrentShip]->ThumbPath).c_str());
}


#endif //SERVER_ONLY
