/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "sample_server.h"

#include "sparklet_utils.h"
#include "exceptions.h"

using namespace std;


SampleServer::~SampleServer() {
	for (map<std::string, SAMPLE*>::iterator x = SampleList.begin(); x != SampleList.end(); ++x)
		destroy_sample(x->second);
}


SAMPLE* SampleServer::GetSample(const std::string &RelPath) {
	const string FullPath = FixFilenameSlashes(string(DATA_PREFIX) + RelPath);

	if (SampleList.find(FullPath) == SampleList.end()) {
		//Check wether the file exists.
		if (!exists(FullPath.c_str()))
			throw ExFileNotFound(FullPath);

		SAMPLE *s = load_sample(FullPath.c_str());
		_SPARKLET_ASSERT(s);

		SampleList.insert(make_pair(FullPath, s));
	}

	SAMPLE *Smp = SampleList.find(FullPath)->second;

	return Smp;
}
