/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef ROTATED_OBJECT_H
#define ROTATED_OBJECT_H

#include "physical_object.h"


class RotatedObject : virtual public PhysicalObject {
public:
	RotatedObject(const TiXmlElement *Att, float Scale);
	~RotatedObject();

	virtual void OnUpdate();

	virtual void CheckData();
	virtual void GetCompleteData(MessageCoder &MC) const;
	virtual void GetChangedData(MessageCoder &MC) const;


protected:
	virtual bool NextFrame(float TimeElapsed);
	virtual bool RenderShape();

	float Direction;
	float Rotation;
	float MomentOfInertia;
	float ShapeResRot;

private:
	bool ShapeDirectionChanged;
	bool ShapeRendered;
	float OldShapeDirection;

	BITMAP *ShapeCache;

	float OldRotation;
	bool DataChanged;
};

#endif
