/***************************************************************************
                          rock.cpp  -  description
                             -------------------
    begin                : Mon Mar 31 2003
    copyright            : (C) 2003 by Milan Mimica
    email                : milan.mimica@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "sprite.h"
#include "rock.h"
#include "game_logic.h"

#include "smoke.h"

#define BASE_SPRITE_STR std::string("base_sprite")
#define PIECE_STR std::string("piece")
#define STRENGTH_STR std::string("strength")

#define PARTS_MAX 5
#define PARTS_MIN 2


extern float gTimeElapsed;
extern GameLogic *gGameLogic;


Rock::Rock(const TiXmlElement* Att, float Scale) :
	Object(Att, Scale),
	MobileObject(Att, Scale),
	PhysicalObject(Att, Scale),
	RoundObject(Att, Scale),
	NonRotatedObject(Att, Scale) {

	Scaled = Scale;

	const TiXmlElement *Root = Parser->GetRoot();

	BaseSprite = GetBaseSprite(Root);

	Strength = XMLParser::GetValueL(Root, STRENGTH_STR, 1) * 200 * Scale;

	Piece = Parser->GetChild(Root, PIECE_STR);

	SmokeList = Parser->GetAllChildren(Root, SMOKE_STR);
}


Rock::~Rock() {
	delete SmokeList;
}


void Rock::OnUpdate() {
	Impulse += CollidingImpulse;
	Velocity += Impulse / Mass;
	LimitSpeed();

	Geo += Velocity * gTimeElapsed;

	Strength -= abs(CollidingImpulse) + CollidingEnergy;
	if (Strength <= 0) {
		HitAngle = arg(CollidingImpulse);
		FallAPart();
		Unlink();
	}

	NextFrame(gTimeElapsed);
	PhysicalObject::OnUpdate();
}


void Rock::FallAPart() {
	if (Geo.Width > 20) {
		const USHORT Pieces = PARTS_MIN + rand() % (PARTS_MAX - PARTS_MIN + 1);
		std::vector<float> Angle = GetExplosionFragmentsAngles(Pieces);

		for (int x = 0; x < Pieces; ++x) {
			Rock *NewRock = new Rock(Piece, Scaled / Pieces);

			float ActualAngle = HitAngle + Angle[x] + M_PI;
			NewRock->SetLoc(Point<float>(Geo.x + cos(ActualAngle) * Geo.Width / 3, Geo.y + sin(ActualAngle) * Geo.Width / 3));

			const float Power = 100 * NewRock->Mass;
			const Vector<float> Mom1(polar(Power + (rand() % 10) * NewRock->Mass, HitAngle));
			const Vector<float> Mom2(polar(Power + (rand() % 10) * NewRock->Mass, ActualAngle));
			NewRock->Impulse = Mom1 + Mom2;
		}
	}
	else
		DoSmoke();
}


void Rock::DoSmoke() {
	const USHORT Count = 6;

	for (USHORT x = 0; x < Count; ++x) {
		const USHORT rnd = rand() % SmokeList->size();
		Smoke *New = new Smoke(SmokeList->at(rnd));

		const float Angle = (2 * M_PI) * ((float)x / (float)Count);
		New->SetImpulse(polar(30.f, Angle));
		New->SetLocC(Geo + Point<float>(Geo.Width / 2, Geo.Height / 2));
	}
}
