/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef PROJECTILE_H
#define PROJECTILE_H

#include "round_object.h"
#include "non-rotated_object.h"

#include <vector>

class Particle;
class Sound;


/* Projectile - abstraction o all kind of projectiles
    - will call Expode and Unlink itself if something touches it.
*/
class Projectile : public RoundObject, public NonRotatedObject {
public:
	Projectile(const TiXmlElement* Att, float Scale = 1.f);
	~Projectile();

	virtual void OnUpdate();

	virtual void AddVelocity(const Vector<float> Vel) {Velocity += Vel;}
	virtual void SetImpulse(const Vector<float> New) {Impulse = New;}

protected:
	virtual Particle* Explode();

private:
	TiXmlElementList DOMParticleList;
	const TiXmlElement *Flame;
	const Sound *ExplosionSound;

	std::string Layout;
	USHORT ParticleCount;

	long RndExplosionImpulse;
	long ExplosionImpulse;
	int ExplosionColor;
};

#endif
