/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "poll.h"

extern float gTimeElapsed;


void Poll::Start(POLL_TYPE lPT, int larg, const std::string &largstr, USHORT lVotersCount) {
	SingleVote.clear();
	SecLeft = 60;
	PT = lPT;
	arg = larg;
	argstr = largstr;
	Active = true;
	VotersCount = lVotersCount;
	EndedEarly = false;
}


bool Poll::Tick() {
	if (!Active)
		return false;

	PollResults lPR;
	GetResults(lPR);
	if (lPR.Yes >= VotersCount / 2 + 1 || lPR.No >= VotersCount / 2 + 1) {
		EndedEarly = true;
		Active = false;
		return true;
	}

	SecLeft -= gTimeElapsed;
	if (SecLeft <= 0) {
		Active = false;
		return true;
	}

	return false;
}


void Poll::GetResults(PollResults &PR) {
	PR.Yes = 0;
	PR.No = 0;
	for (std::map<int, bool>::iterator it = SingleVote.begin(); it != SingleVote.end(); ++it) {
		if (it->second)
			++PR.Yes;
		else
			++PR.No;
	}

	PR.PT = PT;
	PR.arg = arg;
	PR.argstr = argstr;
	PR.EndedEarly = EndedEarly;
}
