/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef PLAYER_OBJECT_H
#define PLAYER_OBJECT_H

#include "rotated_object.h"

#include "object_spring.h"
#include "engine.h"

#include <string>
#include <map>

#define PLAYER_OBJECT_STR std::string("player_object")


class FloatingObject;
class Weapon;
class ObjectsSpring;
class EngineInfo;
class WeaponInfo;
class Sound;


class PlayerObject : public RotatedObject {
public:
	PlayerObject(const TiXmlElement* Att);
	~PlayerObject();

	virtual void OnUpdate();
	virtual const ULONG GetTypeID() const {return GEN_ID('p', 'l', 'o', 'b');}

	virtual void CheckData();
	virtual void GetCompleteData(MessageCoder &MC) const;
	virtual void GetChangedData(MessageCoder &MC) const;

	bool IsOver(FloatingObject *FloObj);

	bool AddEnergy(USHORT E);
	bool AddAmmo(const USHORT Index, const USHORT AmmoCount);
	bool AddWeapon(const USHORT WeaponIndex, const int AmmoCount);

	void SetName(const std::string &N) {Name = N;}

	void Reborn();

protected:
	std::string Name;

	Sprite *Chassis;
	Sprite *EngineChassis;
	Engine *Machinery;
	Sprite *Explosion;

	Vector<float> WeaponLoopBackImpulse;

	std::map<const USHORT, Weapon*> WeaponList;
	std::map<const USHORT, Weapon*> GatheredWeaponList;

	ObjectsSpring SmokeSpring;
	std::vector<SpringParticle*> SmokeParticlesList;

	const ULONG FULL_ENERGY;
	const ULONG EXTRAFULL_ENERGY;
	const ULONG ZERO_ENERGY;

	ULONG Energy;
	ULONG EnergyLast;

	enum STATE {NORMAL, EXPLODING, WAITING, SPAWNING};
	STATE State;

	float SecondsToWait;
	STATE AfterWaitState;

	virtual void OnArenaOut();
	virtual void Unlink();
	virtual void Damage(const PhysicalObject *Obj);
	virtual bool OnCollide(const PhysicalObject *Obj);

	void SwitchToNextWeapon() {SwitchToWeapon(GetNextGatheredWeaponIndex());}
	void SwitchToWeapon(USHORT Index) {ActiveWeaponWaiting = Index;}

	Weapon* GetActiveWeapon() {return GatheredWeaponList[ActiveWeapon];}


	void UpdateEnergy();
	void UpdatePosition();
	void SetSmoke();
	void SetChassis();
	void Explode();

private:
	std::map<const USHORT, Weapon*> InitialGatheredWeapons;
	USHORT ActiveWeapon;
	USHORT ActiveWeaponWaiting;

	USHORT GetBestWeaponIndex();
	USHORT GetNextGatheredWeaponIndex();
	void WeaponSwap();

	void ArrangeWeapons(const TiXmlElement *E);

	Vector<float> AdditionalImpulse;
	Vector<float> OldAdditionalImpulse;
	bool ImpulseChanged;

	IDENTITY LastObjCollided;

	float OldRotation;
	EngineInfo *OldEngInf;
	std::map<const USHORT, WeaponInfo*> OldWeaponInfoList;
	ShipState OldShipState;
	ShipInfo OldShipInfo;

	const Sound *ExplosionSound;

	bool RotationDataChanged;
	bool WeaponDataChanged[10];
	bool EngineDataChanged;
	bool ShipDataChanged;
	bool ImpulseDataChanged;
	bool LocDataChanged;
	bool JustSpawned;
	bool JustTranslocated;
	bool ShipInfoChanged;

	UCHAR EnergyPercent;

	float GetClosestSpotDistance(float off, bool UseX) const;
	virtual float GetSurfaceNormal(const Point<float> &Loc) const;
};

#endif
