/***************************************************************************
                          player.cpp  -  description
                             -------------------
    begin                : Mon Mar 31 2003
    copyright            : (C) 2003 by Milan Mimica
    email                : milan.mimica@gmail.com   
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "player.h"
#include "floating_object.h"

#include "weapon.h"
#include "engine.h"

#include <algorithm>

#include "network_server.h"


using namespace std;

extern NetworkServer *gNetworkServer;


Player::Player(const TiXmlElement *Att, int lClientID) :
	Object(Att, 1),
	MobileObject(Att, 1),
	PhysicalObject(Att, 1),
	ControlledObject(lClientID),
	PlayerObject(Att) {

	gNetworkServer->SetCamera(lClientID, ObjectUID);
}


bool Player::OnKeyUp(const std::set<INPUT_COMMAND> &Key) {
	if (State != NORMAL)
		return false;

	if (!Pressed(IC_POWER_UP, Key)) {
		Machinery->ForwardUp();
	}
	if (!Pressed(IC_MOVE_BACKWARD, Key)) {
		Machinery->BackUp();
	}
	if (!Pressed(IC_TURN_LEFT, Key)) {
		Machinery->RotLeftUp();
	}
	if (!Pressed(IC_TURN_RIGHT, Key)) {
		Machinery->RotRightUp();
	}
	if (!Pressed(IC_STRAFE_LEFT, Key)) {
		Machinery->StrLeftUp();
	}
	if (!Pressed(IC_STRAFE_RIGHT, Key)) {
		Machinery->StrRightUp();
	}
	if (!Pressed(IC_PRIMARY_FIRE, Key) && !Pressed(IC_PRIMARY_FIRE, Key)) {
		WeaponLoopBackImpulse -= GetActiveWeapon()->KeyUp(Weapon::PRIMARY, Direction, Velocity);
	}
	if (!Pressed(IC_PRIMARY_FIRE, Key) && !Pressed(IC_PRIMARY_FIRE, Key)) {
		WeaponLoopBackImpulse -= GetActiveWeapon()->KeyUp(Weapon::SECONDARY, Direction, Velocity);
	}

	return true;
}


bool Player::OnKeyDown(const std::set<INPUT_COMMAND> &Key) {
	if (State != NORMAL)
		return false;

	if (Pressed(IC_POWER_UP, Key)) {
		Machinery->ForwardDown();
	}
	if (Pressed(IC_MOVE_BACKWARD, Key)) {
		Machinery->BackDown();
	}
	if (Pressed(IC_TURN_LEFT, Key)) {
		Machinery->RotLeftDown();
	}
	if (Pressed(IC_TURN_RIGHT, Key)) {
		Machinery->RotRightDown();
	}
	if (Pressed(IC_STRAFE_LEFT, Key)) {
		Machinery->StrLeftDown();
	}
	if (Pressed(IC_STRAFE_RIGHT, Key)) {
		Machinery->StrRightDown();
	}
	if (Pressed(IC_PRIMARY_FIRE, Key) || Pressed(IC_PRIMARY_FIRE, Key)) {
		WeaponLoopBackImpulse -= GetActiveWeapon()->KeyDown(Weapon::PRIMARY, Direction, Velocity);
	}
	if (Pressed(IC_SECONDARY_FIRE, Key) || Pressed(IC_SECONDARY_FIRE, Key)) {
		WeaponLoopBackImpulse -= GetActiveWeapon()->KeyDown(Weapon::SECONDARY, Direction, Velocity);
	}
	if (Pressed(IC_CHANGE_WEAPON, Key)) {
		SwitchToNextWeapon();
	}
	if (Pressed(IC_SELECT_MACHINEGUN, Key)) {
		if (GatheredWeaponList.find(0) != GatheredWeaponList.end())
			SwitchToWeapon(0);
	}
	if (Pressed(IC_SELECT_CANNON, Key)) {
		if (GatheredWeaponList.find(1) != GatheredWeaponList.end())
			SwitchToWeapon(1);
	}
	if (Pressed(IC_SELECT_FUZZYGUN, Key)) {
		if (GatheredWeaponList.find(2) != GatheredWeaponList.end())
			SwitchToWeapon(2);
	}
	if (Pressed(IC_SELECT_BOUNCER, Key)) {
		if (GatheredWeaponList.find(3) != GatheredWeaponList.end())
			SwitchToWeapon(3);
	}
	if (Pressed(IC_SELECT_INTEGRAL, Key)) {
		if (GatheredWeaponList.find(4) != GatheredWeaponList.end())
			SwitchToWeapon(4);
	}
	if (Pressed(IC_SELECT_DERIVATOR, Key)) {
		if (GatheredWeaponList.find(5) != GatheredWeaponList.end())
			SwitchToWeapon(5);
	}
	if (Pressed(IC_SELECT_TORPEDO, Key)) {
		if (GatheredWeaponList.find(6) != GatheredWeaponList.end())
			SwitchToWeapon(6);
	}

	return true;
}


void Player::LostControl() {
	Machinery->Reset();

	ControlledObject::LostControl();
}


void Player::Unlink() {
	ControlledObject::Unlink();
	PlayerObject::Unlink();
}
