/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef PARTICLE_H
#define PARTICLE_H

#include "object.h"

#include "round_object.h"
#include "non-rotated_object.h"

#define EXPL_PARTICLE_STR std::string("expl_particle")


class Particle : public RoundObject, public NonRotatedObject {
public:
	Particle(const TiXmlElement *Att, int ExplosionColor, float Scale = 1.f);

	virtual void OnUpdate();
	virtual void Unlink();
	virtual void GetCompleteData(MessageCoder &MC) const;

	static const ULONG ID;
	const ULONG GetTypeID() const {return ID;}

	void SetImpulse(const Vector<float> New) {Impulse = New;}
	void TakeCamera(int ClientID);

private:
	float EnergyDecrementPerSecond;
	float Duration;
	int Color;
	Sprite *BaseSprite;
	bool TookCamera;
	int CameraClientID;
};

#endif
