/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef OBJECTS_SPRING_H
#define OBJECTS_SPRING_H

#include "structures.h"
#include "xmlparser.h"
#include <list>


struct SpringParticle {
	SpringParticle(const TiXmlElement *Element, const Rect<float> *Dimensions, const float *Angle);

	Point<float> Offset;
	float AngleOffset;
	float Interval;
	float TimeElapsed;

	const Rect<float> *Geo;
	const float *Direction;

	const TiXmlElement *ObjectElement;

	private:
		const float Zero;
};


class ObjectsSpring {
public:
	ObjectsSpring();
	//~ObjectsSpring();
	void Update(float TimeUpdate);

	void Stop() {Stopped = true;}
	void Resume() {Stopped = false;}
	void Add(SpringParticle *Obj) {SpringParticlesList.push_back(Obj);}
	void Remove(SpringParticle *Obj) {SpringParticlesList.remove(Obj);}
	void RemoveOne() {SpringParticlesList.pop_back();}
	USHORT Size() {return SpringParticlesList.size();}

private:
	std::list<SpringParticle*> SpringParticlesList;

	bool Stopped;
};

#endif
