/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef WIN32
#include <allegro.h>
#include <winalleg.h>
#endif

#include "object.h"

#include "object_spring.h"
#include "initializer.h"

#define INTERVAL_STR std::string("interval")
#define OFFSET_X_STR std::string("offset_x")
#define OFFSET_Y_STR std::string("offset_y")
#define ANGLE_OFFSET_STR std::string("angle_offset")


extern Initializer *gInitializer;


SpringParticle::SpringParticle(const TiXmlElement *Element, const Rect<float> *Dimensions, const float *Angle) :
	Zero(0) {

	Geo = Dimensions;
	Direction = Angle;

	if (Direction == NULL)
		Direction = &Zero;

	Interval = XMLParser::GetValueF(Element, INTERVAL_STR, 0.f);
	if (Interval == 0.f) {
		_ERROR_;
		_SAY("No interval given or zero!");
	}

	Offset.x = XMLParser::GetValueF(Element, OFFSET_X_STR, 0.f) * Geo->Width / 100;
	Offset.y = XMLParser::GetValueF(Element, OFFSET_Y_STR, 0.f) * Geo->Height / 100;
	AngleOffset = XMLParser::GetValueF(Element, ANGLE_OFFSET_STR, 0.f);
	TimeElapsed = 0;

	ObjectElement = XMLParser::GetChild(Element, "*");
}


ObjectsSpring::ObjectsSpring() : Stopped(false) {
}


/*ObjectsSpring::~ObjectsSpring() {
	while (!SpringParticlesList.empty())
		delete SpringParticlesList.back();
}*/


void ObjectsSpring::Update(float TimeUpdate) {
	if (Stopped)
		return;

	for (std::list<SpringParticle*>::iterator x = SpringParticlesList.begin(); x != SpringParticlesList.end(); ++x) {
		if ((*x)->TimeElapsed < (*x)->Interval)
			(*x)->TimeElapsed += TimeUpdate;
		else {
			(*x)->TimeElapsed = 0.f;
			Object *New = gInitializer->CreateObject((*x)->ObjectElement);

			const float Dir = *(*x)->Direction + (*x)->AngleOffset;
			const Point<float> Center = *(*x)->Geo + Point<float>((*x)->Geo->Width / 2, (*x)->Geo->Height / 2);
			New->SetLocC(Center + Point<float>(cos(Dir) * (*x)->Offset.x, sin(Dir) * (*x)->Offset.y));
		}
	}
}
