/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <allegro.h>
#ifdef _WIN32
#include <winalleg.h>
#endif

#include "object_extension.h"

#include "non-rotated_object.h"


NonRotatedObject::NonRotatedObject(const TiXmlElement *Att, float Scale) :
	Object(Att, Scale),
	MobileObject(Att, Scale),
	PhysicalObject(Att, Scale),
	ShapeRendered(false) {
}


bool NonRotatedObject::RenderShape() {
	if ((!ShapeChanged) || (IsFixedShape && ShapeRendered))
		return false;

	if (ShapeChanged) {
		clear_to_color(Shape, makecol16(255, 0, 255));
		clear_to_color(tmp, makecol16(255, 0, 255));

		for (USHORT x = 0; x < Extension.size(); ++x)
			Extension[x]->RenderShape(Shape, tmp);
	}

	ShapeChanged = false;
	ShapeRendered = true;

	return true;
}
