/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef WIN32
#include <allegro.h>
#include <winalleg.h>
#endif

#include "mobile_object.h"
#include "object_extension.h"


#define MASS_STR std::string("mass")

#define IMPULSE_X_STR std::string("impulse_x")
#define IMPULSE_Y_STR std::string("impulse_y")

#define SHAPE_RES_STR std::string("shape_res")

#define SPEED_LIMIT_STR std::string("speed_limit")


MobileObject::MobileObject(const TiXmlElement* Att , float Scale) :
	Object(Att, Scale),
	Velocity(0, 0),
	OldVelocity(0, 0) {

	const TiXmlElement *Root = Parser->GetRoot();

	Impulse = Vector<float>(XMLParser::GetValueF(Root, IMPULSE_X_STR, 0.f), XMLParser::GetValueF(Root, IMPULSE_Y_STR, 0.f));
	ShapeRes = XMLParser::GetValueF(Root, SHAPE_RES_STR, 0.1f) * Scale;

	Mass = XMLParser::GetValueF(Root, MASS_STR, 10.f) * Scale;

	Impulse = Vector<float>(XMLParser::GetValueF(Att, IMPULSE_X_STR, Impulse.x), XMLParser::GetValueF(Att, IMPULSE_Y_STR, Impulse.y));

	//3270 is the network protocol limit
	SpeedLimit = XMLParser::GetValueF(Root, SPEED_LIMIT_STR, 3270.f);
	_SPARKLET_ASSERT(SpeedLimit <= 3270.f);
}


bool MobileObject::NextFrame(const float TimeElapsed) {
	bool Update = false;

	for (USHORT x = 0; x < Extension.size(); ++x) {
		if (Extension[x]->NeedsUpdate(TimeElapsed)) {
			Update = true;
			Extension[x]->Update();
		}
	}

	return Update;
}


void MobileObject::OnUpdate() {
	Impulse = Vector<float>(0, 0);
	LimitSpeed();

	Object::OnUpdate();
}


void MobileObject::GetCompleteData(MessageCoder &MC) const {
	VelocityInfo *VI = new VelocityInfo();
	VI->Velocity = Velocity;
	VI->Loc = Geo;
	MC.Put(VI);

	Object::GetCompleteData(MC);
}


void MobileObject::CheckData() {
	if (OldVelocity != Velocity) {
		OldVelocity = Velocity;
		DataChanged = true;
	}
	else
		DataChanged = false;

	Object::CheckData();
}


void MobileObject::GetChangedData(MessageCoder &MC) const {
	if (DataChanged) {
		VelocityInfo *VI = new VelocityInfo();
		VI->Velocity = Velocity;
		VI->Loc = Geo;
		MC.Put(VI);
	}

	Object::GetChangedData(MC);
}


void MobileObject::LimitSpeed() {
	if (abs(Velocity) > SpeedLimit)
		Velocity = polar(SpeedLimit, arg(Velocity));
}


void MobileObject::Unlink() {
	Object::Unlink();
}
