/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef MISSILE_H
#define MISSILE_H


#include "controlled_object.h"
#include "projectile.h"

#define MISSILE_STR std::string("missile")


class Particle;
class Sound;


/* Missile - implements navigated projectile
    - will capture camera and pass it to the object returned by Explode upon expoding
    - will capture game input and release it upon exploding
*/
class Missile : public Projectile, public ControlledObject {
public:
	Missile(const TiXmlElement* Att, int ClientID, float Scale = 1.f);
	~Missile();

	virtual void OnUpdate();

	const ULONG GetTypeID() const {return GEN_ID('m', 's', 'l', 'e');}

	void GetCompleteData(MessageCoder &MC) const;
	void CheckData();
	void GetChangedData(MessageCoder &MC) const;

	virtual void AddVelocity(const Vector<float>) {/*do nothing here because missile has its
		own motor drive (and it's a PITA when playing)*/};

private:
	virtual bool OnKeyDown(const std::set<INPUT_COMMAND> &KeyDown);
	virtual bool OnKeyUp(const std::set<INPUT_COMMAND> &KeyUp);

	virtual void Unlink();
	virtual Particle* Explode();
	virtual void Damage(const PhysicalObject *Obj);

	int CameraClientID;

	float OldRotation;
	float Rotation;
	bool RotationChanged;

	Sprite *BaseSprite;
	Sound *FlySound;
	Particle* NextFocusedObject;
};

#endif
