/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#include "message_writer.h"

#define LINE_STR std::string("line")


MessageWriter::MessageWriter(const TiXmlElement *Att, const Size &Dim, float Scale) :
	GuiObject(Att, Dim) {

	const TiXmlElement *EL = XMLParser::GetChild(Att, LINE_STR);
	Line = new Text(EL, Geo);
	Extension.push_back(Line);
	Line->SetText("|");

	CurrentHistoryLine = 1;
	HistoryLine.push_back("|");

	CliObject::SetVisible(false);
}


void MessageWriter::PopChar() {
	std::string str = Line->GetText();

	if (str.length() <= 1)
		return;

	str = str.substr(0, str.length() - 2)  + '|';

	Line->SetText(str);
}


void MessageWriter::PutChar(char c) {
	std::string str = Line->GetText();
	str = str.substr(0, str.length() - 1) + c + '|';

	Line->SetText(str);
}


void MessageWriter::HistoryBackward() {
	if (CurrentHistoryLine == 0)
		return;

	CurrentHistoryLine--;
	Line->SetText(HistoryLine[CurrentHistoryLine]);
}


void MessageWriter::HistoryForward() {
	if (CurrentHistoryLine + 1 >= (USHORT)HistoryLine.size()) {
		Line->SetText("|");
		return;
	}

	CurrentHistoryLine++;
	Line->SetText(HistoryLine[CurrentHistoryLine]);
}


void MessageWriter::HistoryPush() {
	HistoryLine.push_back(Line->GetText());
	CurrentHistoryLine = HistoryLine.size();
}


#endif //SERVER_ONLY
