/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#ifndef MESSAGE_LISTER_H
#define MESSAGE_LISTER_H

#include "gui_object.h"
#include "initializer.h"

#define MESSAGE_LISTER_STR std::string("message_lister")


#define MSG_LSTR_FONT_COLOR_NORMAL 0xf0ffffff
#define MSG_LSTR_FONT_COLOR_SERVER_MESSAGE 0xf0ff88ff
#define MSG_LSTR_FONT_COLOR_CHAT_MESSAGE 0xf0ccccff
#define MSG_LSTR_FONT_COLOR_TEAM_MESSAGE 0xf06666ff
#define MSG_LSTR_FONT_COLOR_PRIVATE_MESSAGE 0xf03333ff


class Text;

class MessageLister : public GuiObject {
public:
	MessageLister(const TiXmlElement *Att, const Size &Dim, float Scale);

	virtual void OnUpdate();
	void Feed(const std::string &Line);
	//ident text that is about to be fed
	void Ident() {Idented += 2;}
	//deident text that is about to be fed
	void Deident() {if (Idented > 1) Idented -= 2;}
	//set color for the text that is about to be fed
	void SetFontColor(int c) {Color = c;}
	void SetAutohide(bool d) {Autohideable = d;}

private:
	void InsertLine(const std::string &Line);

	std::vector<Text*> LineList;
	float TimeOut;
	float TimeLeft;
	USHORT Idented;
	int Color;
	bool Autohideable;
};

DECLARE_CLI_FACTORY(MessageLister, CliObject)

#endif

#endif //SERVER_ONLY
