/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#include "text.h"
#include "message_lister.h"


#define TIMEOUT_STR std::string("timeout")


extern float gTimeElapsed;


MessageLister::MessageLister(const TiXmlElement *Att, const Size &Dim, float Scale) :
	GuiObject(Att, Dim),
	Idented(0),
	Color(MSG_LSTR_FONT_COLOR_NORMAL),
	Autohideable(true) {

	const TiXmlElementList* Child = XMLParser::GetChildren(Att, TEXT_STR);
	LineList.reserve(Child->size());
	for (USHORT x = 0; x < Child->size(); ++x) {
		Text *New = new Text(Child->at(x), Geo);
		LineList.push_back(New);
		Extension.push_back(New);
	}
	delete Child;

	TimeOut = XMLParser::GetValueF(Att, TIMEOUT_STR, 15.f);
	TimeLeft = 0;
}


void MessageLister::InsertLine(const std::string &Line) {
	std::string IdentStr;

	//shift the lines up
	for (USHORT x = LineList.size() - 1; x > 0; --x) {
		LineList[x]->SetText(LineList[x - 1]->GetText());
		LineList[x]->SetFontColor(LineList[x - 1]->GetColor());
	}

	for (int x = 0; x < Idented; x++)
		IdentStr += " ";

	LineList[0]->SetText(IdentStr + Line);
	LineList[0]->SetFontColor(Color);
}


/* Splits the given line on space characters (if possible) to fit
   into MessageLister. */
void MessageLister::Feed(const std::string &Line) {
	USHORT From = 0;
	unsigned int To;
	const USHORT MaxTextLen = LineList[0]->GetMaxTextLen() - Idented;

	while (From < Line.length()) {
		if (MaxTextLen <= Line.length() - From)
			To = Line.rfind(' ', From + MaxTextLen);
		else
			To = Line.length();

		if (To == std::string::npos || To <= From)
			To = From + MaxTextLen;

		InsertLine(Line.substr(From, To - From));
		From = To;
	}

	TimeLeft = TimeOut;
	SetVisible(true);
}


void MessageLister::OnUpdate() {
	if (Autohideable) {
		TimeLeft -= gTimeElapsed;
		if (TimeLeft < 0)
			TimeLeft = 0;

		if (TimeLeft == 0)
			SetVisible(false);
	}

	GuiObject::OnUpdate();
}


#endif //SERVER_ONLY
