/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef MESSAGE_CODER_H
#define MESSAGE_CODER_H

#include "network_messages.h"

#include <set>


class MessageCoder {
public:
	~MessageCoder();

	void Put(const serializable_c *common);

	void Put(const FullObjInfo *FOI);
	void Put(const ParticleInfo *FOI);

	void Begin(const OUIDInfo &ObjUID);
	void End();

	void PutRemove(const OUIDInfo Die);

	void GetCodedMessage(buffer_c &buf);
	static void Decode(buffer_c &cod, buffer_c &dec);

private:
	buffer_c CommonData;
	buffer_c RawData;

	UCHAR MsgCounter;
	OUIDInfo *CurrentObjUID;


/*---------- begin FullObjectInfo stuff -----------*/
	class FOIODiff;
	struct FOIObject {
		FOIObject() {};
		FOIObject(const OUIDInfo *lObjID, const FullObjInfo* lFOI) :
			ObjID(lObjID), FOI(lFOI) {};

		//do nothing
		//FOIObject& operator=(const FOIODiff &Value) {return *this};
		const OUIDInfo *ObjID;
		const FullObjInfo *FOI;
	};

	struct FOIODestroy {
		void operator()(const FOIObject &x) {delete x.FOI; delete x.ObjID;}
	};

	struct AreFOIONear : public std::binary_function <FOIObject, FOIObject, bool> {
		inline bool operator()(const FOIObject& x, const FOIObject& y) const;
	};

	struct WriteFOIOcod {
		WriteFOIOcod(buffer_c &lData) : Data(lData) {};
		inline void operator() (const FOIObject &x);
	private:
		buffer_c &Data;
	};

	struct WriteFOIOdec {
		WriteFOIOdec(buffer_c &lData) : Data(lData) {};
		inline void operator() (const FOIObject &x);
	private:
		buffer_c &Data;
	};

	typedef std::multiset<FOIObject, AreFOIONear> FOIOListType;
	FOIOListType FOIOList;

	void CodeFOI(buffer_c &Data);
	static void DecodeFOI(buffer_c &cod, buffer_c &dec);
/*---------- end of FullObjectInfo stuff -----------*/

/*---------- begin ParticleInfo stuff -----------*/
	struct PIODiff;
	struct PIObject {
		PIObject() {};
		PIObject(const OUIDInfo *lObjID, const ParticleInfo* lPI) :
			ObjID(lObjID), PI(lPI) {};

		//do nothing
		//PIObject& operator=(const PIODiff &Value) {return *this};
		const OUIDInfo *ObjID;
		const ParticleInfo* PI;
	};

	struct PIODestroy {
		void operator()(const PIObject &x) {delete x.ObjID; delete x.PI;}
	};

	struct ArePIONear : public std::binary_function <PIObject, PIObject, bool> {
		inline bool operator()(const PIObject& x, const PIObject& y) const;
	};

	struct PIODiff {
		//do nothing
		PIODiff& operator=(const PIObject &Value) {return *this;}
		Point<float> LocDiff;
		float Angle;
		float LifeTime;
		float VelocityDiff;
	};

	struct DiffPIO {
		inline PIODiff operator()(const PIObject& x, const PIObject& y) const;
	};

	struct WritePIODiff {
		WritePIODiff(buffer_c &lData) : Data(lData) {};
		inline void operator() (const PIODiff &x) const;
	private:
		buffer_c &Data;
	};

	struct ReadPIODiff {
		ReadPIODiff(buffer_c &lData) : Data(lData) {};
		inline void operator() (PIODiff &x) const;
	private:
		buffer_c &Data;
	};

	struct WritePIOcod {
		WritePIOcod(buffer_c &lData) : Data(lData) {};
		inline void operator() (const PIObject &x);
	private:
		buffer_c &Data;
	};

	struct WritePIOdec {
		WritePIOdec(buffer_c &lData) : Data(lData) {};
		inline void operator() (const PIObject &x);
	private:
		buffer_c &Data;
	};

	typedef std::multiset<PIObject, ArePIONear> PIOListType;
	PIOListType PIOList;

	void CodePI(buffer_c &Data);
	static void DecodePI(buffer_c &cod, buffer_c &dec);
/*---------- end of ParticleInfo stuff -----------*/

/*---------- begin Remove stuff -----------*/
	void CodeRemove(buffer_c &Data);
	static void DecodeRemove(buffer_c &cod, buffer_c &dec);

	typedef std::set<OUIDInfo> RemoveListType;
	RemoveListType RemoveList;
/*---------- end of Remove stuff -----------*/
};

#endif
