/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#ifndef MAP_SELECTOR_H
#define MAP_SELECTOR_H


#include <MASkinG.h>
#include <vector>
#include <string>


class MapSelector : public MAS::Dialog {
public:
	MapSelector();
	~MapSelector();

	std::vector<std::string> GetMapPathList();
	void SaveSettings();

	struct MapInfo {
		MapInfo(const std::string &lPath) : Path(lPath) {}
		const std::string Path;
		std::string Name;
		std::string ThumbPath;
		std::string Description;
	};

private:
	MAS::Image iThumb;
	MAS::Button bNext, bPrevious;
	MAS::Label lDesc, lName;

	std::vector<MapInfo*> MapInfoList;
	short int CurrentMap;

	void GetMapFiles();
	void ParseMapFiles();
	void SelectCurrentMap();

	virtual void HandleEvent(Widget &obj, int msg, int arg1 = 0, int arg2 = 0);
};

#endif

#endif //SERVER_ONLY
