/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#include "map_selector.h"
#include "structures.h"
#include "xmlparser.h"
#include <string>
#include <algorithm>


MapSelector::MapSelector() {
	iThumb.Shape(0, 0, 200, 200);
	iThumb.ClearFlag(D_AUTOSIZE);

	bPrevious.Shape(215, 180, 60, 20);
	bPrevious.SetText("Previous");
	bNext.Shape(285, 180, 60, 20);
	bNext.SetText("Next");

	lName.Shape(215, 0, 200, 20);

	lDesc.Shape(215, 30, 240, 100);
	lDesc.SetWordWrap(true);

	GetMapFiles();
	ParseMapFiles();

	CurrentMap = get_config_int("client", "map_index", 0);
	SelectCurrentMap();

	Add(bPrevious);
	Add(bNext);
	Add(iThumb);
	Add(lName);
	Add(lDesc);
}


MapSelector::~MapSelector() {
	for (USHORT i = 0; i < MapInfoList.size(); ++i)
		delete MapInfoList[i];
}


std::vector<std::string> MapSelector::GetMapPathList() {
	std::vector<std::string> RetVal;
	RetVal.reserve(MapInfoList.size());

	for (USHORT i = CurrentMap; i < MapInfoList.size(); ++i) {
		const std::string FullPath = MapInfoList[i]->Path;
		int length = strlen(FullPath.c_str());
		char *_RelPath = (char*)malloc(length);
		const std::string RelPath(make_relative_filename(_RelPath, DATA_PREFIX, FullPath.c_str(), length));
		free(_RelPath);

		RetVal.push_back(RelPath);
	}

	for (USHORT i = 0; i < CurrentMap; ++i) {
		const std::string FullPath = MapInfoList[i]->Path;
		int length = strlen(FullPath.c_str());
		char *_RelPath = (char*)malloc(length);
		const std::string RelPath(make_relative_filename(_RelPath, DATA_PREFIX, FullPath.c_str(), length));
		free(_RelPath);

		RetVal.push_back(RelPath);
	}

	return RetVal;
}


void MapSelector::SaveSettings() {
	set_config_int("client", "map_index", CurrentMap);
}


int GetMapsHelper(const char *filename, int attrib, void *MapInfoList) {
	if (attrib & FA_DIREC)
		return 0;

	if (strstr(filename + strlen(filename) - 4, ".nsa"))
		static_cast<std::vector<MapSelector::MapInfo*>* >(MapInfoList)->push_back(
			new MapSelector::MapInfo(filename));

	return 0;
}


void MapSelector::GetMapFiles() {
	const std::string SharedPath = std::string(DATA_PREFIX) + "defs/maps/" + "*";
	for_each_file_ex(SharedPath.c_str(), 0, 0, GetMapsHelper, &MapInfoList);
	_SPARKLET_ASSERT(MapInfoList.size());
}


void MapSelector::ParseMapFiles() {
	for (USHORT i = 0; i < MapInfoList.size(); ++i) {
		MapInfo *const VI = MapInfoList[i];
		XMLParser Parser(VI->Path);
		const TiXmlElement *const XMLRoot = Parser.GetRoot();

		VI->Name = XMLParser::GetValueS(XMLRoot, "name", "");
		VI->Description = XMLParser::GetValueS(XMLRoot, "desc", "");
		VI->ThumbPath = XMLParser::GetValueS(XMLRoot, "thumb", "");
	}
}


void MapSelector::HandleEvent(Widget &obj, int msg, int arg1, int arg2) {
	Dialog::HandleEvent(obj, msg, arg1, arg2);

	switch (msg) {
		case MSG_ACTIVATE:
			if (obj == bPrevious)
				++CurrentMap;
			else if (obj == bNext)
				--CurrentMap;

			if (CurrentMap < 0)
				CurrentMap = MapInfoList.size() - 1;
			else if ((USHORT)CurrentMap >= MapInfoList.size())
				CurrentMap = 0;

			SelectCurrentMap();
		break;
	}
}


void MapSelector::SelectCurrentMap() {
	lDesc.SetText(MapInfoList[CurrentMap]->Description.c_str());
	lName.SetText(MapInfoList[CurrentMap]->Name.c_str());
	Dialog::GetParent()->Redraw();

	if (exists((DATA_PREFIX + MapInfoList[CurrentMap]->ThumbPath).c_str()))
		iThumb.SetBitmap((DATA_PREFIX + MapInfoList[CurrentMap]->ThumbPath).c_str());
	else {
		_ERROR_;
	}
}



#endif //SERVER_ONLY
