/***************************************************************************
                          initializer.h  -  description
                             -------------------
    begin                : Sat Oct 25 2003
    copyright            : (C) 2003 by Milan Mimica
    email                : milan.mimica@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef INITIALIZER_H
#define INITIALIZER_H

#include <string>
#include <map>

#include "structures.h"
#include "xmlparser.h"


class Object;
class CliObject;
class Player;


class ObjectFactory {
public:
	virtual ~ObjectFactory() {};
	virtual Object* operator()(const TiXmlElement* Element, float Scale) = 0;
};


#ifndef SERVER_ONLY
class CliObjectFactory {
public:
	virtual ~CliObjectFactory() {};
	virtual CliObject* operator()(const TiXmlElement* Element, const Size &Dim, float Scale) = 0;
};
#endif //SERVER_ONLY

int FillPaths(const char *filename, int attrib, void *Paths);


class Initializer {
public:
	Initializer();
	~Initializer();

	Object* CreateObject(const TiXmlElement *Element, float Scale = 1.f);
#ifndef SERVER_ONLY
	CliObject* CreateCliObject(const TiXmlElement *Element, const Size &Dim, float Scale);
#endif //SERVER_ONLY

private:
	std::map<const std::string, ObjectFactory*> ObjectFactoryes;
#ifndef SERVER_ONLY
	std::map<const std::string, CliObjectFactory*> CliObjectFactoryes;
#endif //SERVER_ONLY
};

#endif
