/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#ifndef GUI_SERVER_OPTIONS
#define GUI_SERVER_OPTIONS

#include <alleggl.h>
#undef RootWindow

#include <MASkinG.h>
#include "map_selector.h"
#include "structures.h"

class NetworkServer;


class GUIServerOptions : public MAS::Window {
public:
	GUIServerOptions(NetworkServer *srv);

private:
	MAS::Button bStart;
	MAS::Button bCancel;

	MAS::EditBox ePort, eName, eMsg, ePassword;
	MAS::SpinBox sTimeOut, sMaxPlayers, sNetRatio, sMaxPoints, sFrendlyFire;
	MAS::ComboBox cGameType;
	MAS::CheckBox cCompression, cReliable;

	MAS::Label lPort, lMaxPlayers, lTimeOut, lName, lMsg, lPassword, lMap, lGameType, lNetRatio,
		lMaxPoints, lFrendlyFire;

	MAS::GroupBox gMapSelectorPanel;
	MapSelector MapSel;

	NetworkServer *const Server;

	void SaveSettings();

	virtual void HandleEvent(Widget &obj, int msg, int arg1 = 0, int arg2 = 0);
};

#endif

#endif //SERVER_ONLY
