/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#ifndef GUI_GAME_OPTIONS
#define GUI_GAME_OPTIONS

#include <alleggl.h>
#undef RootWindow
#undef MessageBox

#include <MASkinG.h>

#include "structures.h"


#define KEY_COUNT 18


#ifndef SERVER_ONLY
	#ifdef ALLEGRO_WINDOWS
		const char *const SOUND_DRIVER_NAME[] = {"none", "DirectX", "DirectX Allegro mix", "waveout low quality", "waveout high quality"};
		const int SoundDriver[] = {DIGI_NONE, DIGI_DIRECTX(0), DIGI_DIRECTAMX(0), DIGI_WAVOUTID(1), DIGI_WAVOUTID(0)};
	#endif
	#ifdef ALLEGRO_UNIX
		const char *const SOUND_DRIVER_NAME[] = {"none", "OSS", "ALSA"};
		const int SoundDriver[] = {DIGI_NONE, DIGI_OSS, DIGI_ALSA};
	#endif

	const int SD_COUNT = sizeof(SoundDriver) / sizeof(int);
#endif //SERVER_ONLY


class KeyConfigurator : public MAS::Dialog {
public:
	KeyConfigurator();

	void SaveKeys();
	void SetKeys();

private:
	void LoadKeys();

	MAS::Label lPriKey, lSecKey;

	MAS::ComboBox cPriKey[KEY_COUNT], cSecKey[KEY_COUNT];
	MAS::Label lKeyFunction[KEY_COUNT];

	MAS::GroupBox gKeysPanel;
};


class MiscOptions : public MAS::Dialog {
public:
	MiscOptions();

	void SetSounds();
	void SaveSounds(Dialog *Parent);

	void SaveGraphics(Dialog *Parent);

private:
	MAS::GroupBox gSoundPanel, gGraphicsPanel;

	MAS::Slider slSoundVolume, slMixerQuality;
	MAS::CheckBox chGUISound, chHardwareMixer, chWindowed;
	MAS::ComboBox cResolution, cSoundDriver;

	MAS::Label lSoundVolume, lSoundVolMin, lSoundVolMax, lMixerQuality, lMixerQuaMin, lMixerQuaMax, lSoundDriver;
	MAS::Label lGUISound, lResolution;

	void FillWithGfxModes(MAS::ComboBox &cb);
	void FillWithSoundDrivers(MAS::ComboBox &cb);
};


class GUIGameOptions : public MAS::Window {
public:
	GUIGameOptions();

private:
	MAS::Button bOK;
	MAS::Button bCancel;

	KeyConfigurator KeyConfig;
	MiscOptions GameOpt;

	MAS::TabPanel TP;

	virtual void HandleEvent(Widget &obj, int msg, int arg1 = 0, int arg2 = 0);
};

#endif

#endif //SERVER_ONLY
