/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#ifndef GUI_CLIENT_OPTIONS_H
#define GUI_CLIENT_OPTIONS_H

#include <alleggl.h>
#undef RootWindow

#include <MASkinG.h>

#include "server_selector.h"
#include "ship_selector.h"
#include "structures.h"

class NetworkClient;


class GUIClientOptions : public MAS::Window {
public:
	GUIClientOptions(NetworkClient *cli);
	void Process();

private:
	MAS::Button bStart;
	MAS::Button bCancel;

	MAS::EditBox eName, ePassword;
	MAS::ComboBox cTeam;
	MAS::Label lName, lPassword, lTeam;

	MAS::GroupBox gShipSel;

	NetworkClient *const Client;
	ServerSelector SrvSel;
	ShipSelector ShipSel;

	void SaveSettings();

	virtual void HandleEvent(Widget &obj, int msg, int arg1 = 0, int arg2 = 0);
};

#endif

#endif //SERVER_ONLY
