/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#include <alleggl.h>
#undef MessageBox


#include "gui_client_options.h"
#include "game_gui.h"
#include "network_client.h"


using namespace MAS;

extern bool SwitchDisplay;


GUIClientOptions::GUIClientOptions(NetworkClient *cli) :
	Window(),
	Client(cli) {

	title.SetText("Start client");
	ClearFlag(D_RESIZABLE);
	MAS::Window::Centre();

	Shape(250, 50, 500, 550);

	bStart.Shape(25, 95, 20, 4, true);
	bStart.SetText("START");
	bCancel.Shape(55, 95, 20, 4, true);
	bCancel.SetText("CANCEL");

	eName.Setup(10, 450, 130, 20, 0, 0, get_config_string("client", "name", ""), 15);

	cTeam.Setup(150, 450, 100, 20, 0, 0, 0);
	cTeam.list.InsertItem(new ListItemString("blue"), 0);
	cTeam.list.InsertItem(new ListItemString("red"), 1);
	cTeam.list.InsertItem(new ListItemString("yellow"), 2);
	cTeam.list.InsertItem(new ListItemString("green"), 3);

	ePassword.Setup(260, 450, 130, 20, 0, 0, "", 15);

	lName.Setup(13, 437, 50, 20, 0, 0, "player name");
	lTeam.Setup(153, 437, 30, 20, 0, 0, "team");
	lPassword.Setup(260, 437, 30, 20, 0, 0, "password");

	gShipSel.Shape(10, 230, 460, 200);
	gShipSel.SetTitle("ship selector");

	SrvSel.Shape(10, 10, 400, 290);
	ShipSel.Shape(20, 250, 430, 185);

	Add(bStart);
	Add(bCancel);

	Add(eName);
	Add(ePassword);

	Add(cTeam);

	Add(lName);
	Add(lPassword);
	Add(lTeam);

	Add(gShipSel);

	Add(SrvSel);
	Add(ShipSel);
}



void GUIClientOptions::Process() {
	SrvSel.Process();
}


void GUIClientOptions::HandleEvent(Widget &obj, int msg, int arg1, int arg2) {
	Window::HandleEvent(obj, msg, arg1, arg2);

	switch (msg) {
		case MSG_ACTIVATE:
			if (obj == bCancel) {
				Close();
			}
			else if (obj == bStart) {
				ClientOptions CO;
				CO.ServerAddress = SrvSel.GetSelectedAddress();
				CO.XMLFileShipPath = ShipSel.GetShipPath();
				CO.Name = eName.GetText();
				CO.Password = ePassword.GetText();

				CO.Team = static_cast<TEAM>(cTeam.list.Selection());

				if (CO.Name.length() == 0) {
					Dialog *GG = Widget::GetParent();
					GG->HandleEvent(*this, MSG_INVALID_PLAYER_NAME_MSGB);
					return;
				}

				if (CO.ServerAddress.size() < 3) {
					Dialog *GG = Widget::GetParent();
					GG->HandleEvent(*this, MSG_INVALID_SERVER_MSGB);
					return;
				}

				if (Client->Connect("defs/gui/default.nsg", CO)) {
					SwitchDisplay = true;
					SaveSettings();
					Close();
				}
				else {
					Dialog *GG = Widget::GetParent();
					GG->HandleEvent(*this, MSG_CLIENT_ERROR_MSGB);
					return;
				}
			}
		break;
	}
}


void GUIClientOptions::SaveSettings() {
	set_config_string("client", "name", eName.GetText());
	ShipSel.SaveSettings();
}


#endif //SERVER_ONLY
