/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef GRANT_OBJECT_H
#define GRANT_OBJECT_H


#include "floating_object.h"


class PlayerObject;
class Sprite;


class IncrecreaseObject : public FloatingObject {
public:
	IncrecreaseObject(const TiXmlElement *Att, float Scale);

	virtual void OnOver(PlayerObject* PlaObj);
	virtual void OnUpdate();

	virtual void CheckData();
	virtual void GetCompleteData(MessageCoder &MC) const;
	virtual void GetChangedData(MessageCoder &MC) const;

	void SetUseOnceAndDestroy(bool b) {UseOnceAndDestroy = b;}

protected:
	bool UseOnceAndDestroy;

private:
	virtual bool Increcrease(PlayerObject* PlaObj) = 0;

	Sprite *BaseSprite;
	float TimeLeft;
	float TimeWaiting;

	AspectInfo OldAspectInfo;
	bool AspectDataChanged;
};


#endif
