/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "sprite.h"
#include "grant_object.h"


#define TIME_WAITING_STR std::string("time_waiting")


extern float gTimeElapsed;


IncrecreaseObject::IncrecreaseObject(const TiXmlElement *Att, float Scale) :
	Object(Att, Scale),
	FloatingObject(Att, Scale) {

	const TiXmlElement *Root = Parser->GetRoot();

	BaseSprite = GetBaseSprite(Root);

	TimeWaiting = XMLParser::GetValueF(Root, TIME_WAITING_STR, 60.f);
	TimeWaiting = XMLParser::GetValueF(Att, TIME_WAITING_STR, TimeWaiting);
	TimeLeft = 0;

	OldAspectInfo.Visible = false;
	UseOnceAndDestroy = false;
}


void IncrecreaseObject::OnUpdate() {
	if (TimeLeft > 0) {
		TimeLeft -= gTimeElapsed;
		if (TimeLeft <= 0)
			BaseSprite->Play();
	}

	FloatingObject::OnUpdate();
}


void IncrecreaseObject::OnOver(PlayerObject *PlaObj) {
	if (TimeLeft <= 0) {
		if (Increcrease(PlaObj)) {
			if (!UseOnceAndDestroy) {
				BaseSprite->Stop();
				TimeLeft = TimeWaiting;
			}
			else
				Unlink();
		}
	}
}


void IncrecreaseObject::CheckData() {
	AspectInfo AI;
	AI.Visible = (TimeLeft <= 0);

	if (AI != OldAspectInfo) {
		OldAspectInfo = AI;
		AspectDataChanged = true;
	}
	else
		AspectDataChanged = false;

	FloatingObject::CheckData();
}


void IncrecreaseObject::GetCompleteData(MessageCoder &MC) const {
	AspectInfo *AI = new AspectInfo();
	AI->Visible = (TimeLeft <= 0);
	MC.Put(AI);

	FloatingObject::GetCompleteData(MC);
}


void IncrecreaseObject::GetChangedData(MessageCoder &MC) const {
	if (AspectDataChanged) {
		AspectInfo *AI = new AspectInfo();
		AI->Visible = (TimeLeft <= 0);
		MC.Put(AI);
	}

	FloatingObject::GetChangedData(MC);
}
