/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifdef WIN32
#include <allegro.h>
#include <winalleg.h>
#endif


#include "game_logic.h"

#include "bullet.h"
#include "particle.h"
#include "rock.h"
#include "wall.h"
#include "smoke.h"

#include <algorithm>


void GameLogic::AddSpawnPlace(SpawnPlace *SP) {
	SpawnPlaceList.push_back(SP);
}


void GameLogic::RemoveSpawnPlace(SpawnPlace *SP) {
	SpawnPlaceList.erase(find(SpawnPlaceList.begin(), SpawnPlaceList.end(), SP));
}


SpawnPlace* GameLogic::GetFreeSpawnPlace() {
	FreeSpawnPlace.clear();

	_SPARKLET_ASSERT(SpawnPlaceList.size());

	for (USHORT x = 0; x < SpawnPlaceList.size(); ++x)
		if (SpawnPlaceList[x]->IsFree())
			FreeSpawnPlace.push_back(SpawnPlaceList[x]);

	if (FreeSpawnPlace.size())
		return FreeSpawnPlace[(int)((float)FreeSpawnPlace.size() * rand() / (RAND_MAX + 1.0f))];
	else
		return NULL;
}


bool GameLogic::CanCollide(const ULONG Obj1ID, const ULONG Obj2ID) const {
	if (Obj1ID == Smoke::ID || Obj2ID == Smoke::ID)
		return false;

	if (Obj1ID == Bullet::ID)
		return Obj2ID != Particle::ID;

	if (Obj1ID == Particle::ID)
		return Obj2ID != Bullet::ID && Obj2ID != Particle::ID;

	if (Obj1ID == Wall::ID)
		return Obj2ID != Wall::ID;

	return true;
}
