/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef GAME_INPUT_H
#define GAME_INPUT_H

#ifndef SERVER_ONLY

#include <set>
#include <map>

#include <allegro.h>

#ifdef WIN32
	#include <winalleg.h>
#endif

#endif //SERVER_ONLY


enum INPUT_COMMAND {
	IC_POWER_UP = 0,
	IC_MOVE_BACKWARD,
	IC_TURN_LEFT,
	IC_TURN_RIGHT,
	IC_STRAFE_LEFT,
	IC_STRAFE_RIGHT,

	IC_PRIMARY_FIRE,
	IC_SECONDARY_FIRE,
	IC_CHANGE_WEAPON,

	IC_SELECT_MACHINEGUN,
	IC_SELECT_CANNON,
	IC_SELECT_FUZZYGUN,
	IC_SELECT_BOUNCER,
	IC_SELECT_INTEGRAL,
	IC_SELECT_DERIVATOR,
	IC_SELECT_TORPEDO,

	IC_SWITCH_DISPLAY,
	IC_SWITCH_SCORE_TABLE_DISPLAY,
	IC_SWITCH_MESSAGE_WRITER,
	IC_SWITCH_STATISTICS,

	IC_ZOOM_IN,
	IC_ZOOM_OUT
};


#ifndef SERVER_ONLY

class GameInput {
public:
	void Process();
	const std::set<INPUT_COMMAND>& Update();
	bool IsSwitchKeyPressed() {return Pressed.find(IC_SWITCH_DISPLAY) != Pressed.end();}

	static std::map<int, INPUT_COMMAND> CommandDecoder;

private:
	std::set<INPUT_COMMAND> lPressed;
	std::set<INPUT_COMMAND> Pressed;
};


#endif //SERVER_ONLY

#endif

