/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY

#include <allegro.h>

#ifdef WIN32
#include <winalleg.h>
#endif

#include "game_input.h"


#include "structures.h"


std::map<int, INPUT_COMMAND> GameInput::CommandDecoder;


const std::set<INPUT_COMMAND>& GameInput::Update() {
	Pressed = lPressed;
	lPressed.clear();
	return Pressed;
}


void GameInput::Process() {
	for (USHORT x = 1; x < KEY_MAX; ++x) {
		const std::map<int, INPUT_COMMAND>::iterator it = CommandDecoder.find(x);
		if (key[x] && it != CommandDecoder.end())
			lPressed.insert(it->second);
	}
}


#endif //SERVER_ONLY
