/***************************************************************************
                          game.h  -  description
                             -------------------
    begin                : Fri Feb 28 2003
    copyright            : (C) 2003 by Milan Mimica
    email                : milan.mimica@gmail.com    
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GAME_H
#define GAME_H

#ifdef SERVER_ONLY
#include <string>
#endif

#ifndef SERVER_ONLY
class GameGUI;
class NetworkClient;
#endif //SERVER_ONLY

class Game {
public:
#ifndef SERVER_ONLY
	Game() : Showing(DT_GUI) {};

	bool Start();
#else
	bool StartServerOnly(const std::string &ProfileFilePath, bool RunInBackground);
#endif //SERVER_ONLY

private:
#ifndef SERVER_ONLY
	bool InitSound();
	bool InitGraphics();

	bool PerformOGLTest();
	bool AreMicrosoftDrivers();

	bool InitTimers();

	void OnDisplaySwitch(NetworkClient *cli, GameGUI *gui);
	enum DISPLAY_TARGET {DT_GUI, DT_GAME};
	DISPLAY_TARGET Showing;
#endif //SERVER_ONLY
};

#endif
