/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#include "fps_display.h"

#include "text.h"
#include <zig/utils.h>


#define FPS_DISPLAY_STR std::string("fps_display")
#define NET_UP_STR std::string("net_up")
#define NET_DOWN_STR std::string("net_down")
#define NET_COMPRESS_STR std::string("net_compress")


extern volatile int gFPS;
extern float gTimeElapsed;


FPSDisplay::FPSDisplay(const TiXmlElement *Root, const Size &Dim, float) :
	GuiObject(Root, Dim),
	TimeToWait(1.f),
	TimeElapsed(0.f) {

	const TiXmlElement *Element = XMLParser::GetChild(Root, FPS_DISPLAY_STR);
	FPS = new Text(Element, Geo);
	Extension.push_back(FPS);

	Element = XMLParser::GetChild(Root, NET_UP_STR);
	NetUp = new Text(Element, Geo);
	Extension.push_back(NetUp);

	Element = XMLParser::GetChild(Root, NET_DOWN_STR);
	NetDown = new Text(Element, Geo);
	Extension.push_back(NetDown);

	Element = XMLParser::GetChild(Root, NET_COMPRESS_STR);
	NetCompress = new Text(Element, Geo);
	Extension.push_back(NetCompress);

	Visible = false;
}


void FPSDisplay::OnUpdate() {
	if (TimeElapsed >= TimeToWait) {
		TimeElapsed = 0.f;

		FPS->SetText(gFPS);
		NetUp->SetText(zig_avg_out());
		NetDown->SetText(zig_avg_in());
		NetCompress->SetText((float)zig_avg_compression_gain());

		GuiObject::OnUpdate();
	}
	else
		TimeElapsed += gTimeElapsed;
}


#endif //SERVER_ONLY
