/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef ENGINE2_H
#define ENGINE2_H

#include "engine.h"
#include "structures.h"

#define ON true
#define OFF false


class Sprite;
class Sound;
class StaticalSprite;


class Engine2 : public Engine {
public:
	Engine2(const TiXmlElement *Element, const Rect<float> &Parent, bool SrvMode);
	~Engine2();

	virtual bool NeedsUpdate(float TimeElapsed);
	virtual void Reset();

	virtual void ForwardDown() {FwdUp.State = ON; FwdDown.State = ON;}
	virtual void BackDown() {RetUp.State = ON; RetDown.State = ON;}
	virtual void RotLeftDown() {RotUpRight.State = ON; RotDownLeft.State = ON;}
	virtual void RotRightDown() {RotUpLeft.State = ON; RotDownRight.State = ON;}
	virtual void StrLeftDown() {}
	virtual void StrRightDown() {}

	virtual void ForwardUp() {FwdUp.State = OFF; FwdDown.State = OFF;}
	virtual void BackUp() {RetUp.State = OFF; RetDown.State = OFF;}
	virtual void RotLeftUp() {RotUpRight.State = OFF; RotDownLeft.State = OFF;}
	virtual void RotRightUp() {RotUpLeft.State = OFF; RotDownRight.State = OFF;}
	virtual void StrLeftUp() {}
	virtual void StrRightUp() {}

	virtual float GetForward();
	virtual float GetTorque();
	virtual float GetStrafe() {return 0;}

	virtual EngineInfo* GetEngineInfo();
#ifndef SERVER_ONLY
	virtual void SetEngineFlame(const EngineInfo* EI);
#endif //SERVER_ONLY

private:
	void SetEnergy(float TimeElapsed);

	struct Engn {
		bool State;

		float Power;
		float MaxForce;
		float CurrentForce;

		Sprite *Flame;
		const Sound *FlameSnd;
	} RetUp,
	RetDown,
	RotUpLeft,
	RotUpRight,
	RotDownLeft,
	RotDownRight,
	FwdUp,
	FwdDown;

	Engn* EngnList[7];
	bool OldEngnState[4];
};


#endif
