/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#ifndef CLI_PLAYER_OBJECT_H
#define CLI_PLAYER_OBJECT_H


#include "cli_rotated_object.h"
#include "physical_object.h"
#include "initializer.h"

class Engine;
class Statusbar;
class Weapon;
class Text;


class CliPlayerObject : public CliRotatedObject {
public:
	CliPlayerObject(const TiXmlElement *Root, const Size &Dim, float Scale, Statusbar *lStb = NULL);

	virtual void OnUpdate();
	virtual void SetMsg(const FullRotationInfo *);
	virtual void SetMsg(const FullVelocityInfo *VI);
	virtual void SetMsg(const EngineInfo *);
	virtual void SetMsg(const WeaponInfo *);
	virtual void SetMsg(const ShipState *);
	virtual void SetMsg(const ShipInfo *);

private:
	float ShapeResRot;
	float MomentOfInertia;

	float Torque;

	float ShapeRes;
	float Mass;

	Vector<float> Impulse;

	Engine *Machinery;
	Sprite *Chassis;
	Sprite *EngineChassis;
	Sprite *Explosion;
	Text *Name;

	std::map<int, Weapon*> WeaponList;
	USHORT ActiveWeapon;

	Statusbar *Stb;

	IDENTITY Identity;

	void UpdateRotation();
	void UpdateVelocity();

	void ArrangeWeapons(const TiXmlElement *Root);
};

DECLARE_CLI_FACTORY(CliPlayerObject, CliObject)

#endif

#endif //SERVER_ONLY
