/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#ifndef CLI_OBJECT_H
#define CLI_OBJECT_H

#include "xmlparser.h"
#include "structures.h"
#include <vector>


class Sprite;
class StaticalSprite;
class ObjectExtension;

class AspectInfo;
class VelocityInfo;
class RotationInfo;
class FullRotationInfo;
class FullVelocityInfo;
class EngineInfo;
class WeaponInfo;
class ShipState;
class ShipInfo;
class ParticleInfo;
class StateInfoGeneric1;
class StateInfoGeneric2;


class CliObject {
public:
	CliObject(const TiXmlElement *Root, const Size &Dim);
	virtual ~CliObject();

	virtual void OnUpdate();

	virtual void SetMsg(const AspectInfo *);
	virtual void SetMsg(const VelocityInfo *) {};
	virtual void SetMsg(const RotationInfo *) {};
	virtual void SetMsg(const FullRotationInfo *) {};
	virtual void SetMsg(const FullVelocityInfo *) {};
	virtual void SetMsg(const EngineInfo *) {};
	virtual void SetMsg(const WeaponInfo *) {};
	virtual void SetMsg(const ShipState *) {};
	virtual void SetMsg(const ShipInfo *) {};
	virtual void SetMsg(const ParticleInfo *) {};
	virtual void SetMsg(const StateInfoGeneric1 *) {};
	virtual void SetMsg(const StateInfoGeneric2 *) {};

	void Render() const;

	inline void SetCamera(const Rect<float> *const CamGeo) {CameraGeo = CamGeo;}
	inline void SetVisible(bool v) {Visible = v;}

	inline const Rect<float>& GetGeo() const {return Geo;}

protected:
	Rect<float> Geo;
	float Direction;

	bool ImageChanged;

	bool Visible;

	const Rect<float> *CameraGeo;
	std::vector<ObjectExtension*> Extension;

	inline Sprite* GetBaseSprite() {return BaseSprite;}
	inline StaticalSprite* GetBaseBitmap() {return BaseBitmap;}
	void ResetExtensions();

private:
	Sprite *BaseSprite;
	StaticalSprite *BaseBitmap;

	void NextFrame();

	void LoadExtensions(const TiXmlElement *XMLRoot);

	virtual Point<float> GetRenderLoc() const = 0;
};

#endif

#endif //SERVER_ONLY
