/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#include "statical_sprite.h"
#include "text.h"
#include "sprite.h"

#include "cli_object.h"

#include "network_messages.h"


#define BASE_SPRITE_STR std::string("base_sprite")
#define BASE_BITMAP_STR std::string("base_bitmap")

#define LAYER_COUNT 5

extern float gTimeElapsed;


CliObject::CliObject(const TiXmlElement *Root, const Size &Dim) :
	Direction(0),
	Visible(true) {

	Geo.Width = Dim.Width;
	Geo.Height = Dim.Height;

	LoadExtensions(Root);
}


void CliObject::LoadExtensions(const TiXmlElement *XMLRoot) {
	const TiXmlElementList* Child = XMLParser::GetAllChildren(XMLRoot, SPRITE_STR);
	for (USHORT x = 0; x < Child->size(); ++x) {
		Extension.push_back(new Sprite(Child->at(x), Geo, false));
	}
	delete Child;

	Child = XMLParser::GetAllChildren(XMLRoot, STATICAL_SPRITE_STR);
	for (USHORT x = 0; x < Child->size(); ++x) {
		Extension.push_back(new StaticalSprite(Child->at(x), Geo, false));
	}
	delete Child;

	Child = XMLParser::GetAllChildren(XMLRoot, TEXT_STR);
	for (USHORT x = 0; x < Child->size(); ++x) {
		Extension.push_back(new Text(Child->at(x), Geo));
	}
	delete Child;

	Child = XMLParser::GetAllChildren(XMLRoot, BASE_SPRITE_STR);
	if (Child->size() == 1) {
		BaseSprite = new Sprite(Child->at(0), Geo, false);
		Extension.push_back(BaseSprite);
	}
	delete Child;

	Child = XMLParser::GetAllChildren(XMLRoot, BASE_BITMAP_STR);
	if (Child->size() == 1) {
		BaseBitmap = new StaticalSprite(Child->at(0), Geo, false);
		Extension.push_back(BaseBitmap);
	}
	delete Child;
}


CliObject::~CliObject() {
	while (!Extension.empty()) {
		delete Extension.back();
		Extension.pop_back();
	}
}


void CliObject::Render() const {
	if (Visible == false)
		return;

	const Point<float> Where = GetRenderLoc();

	for (USHORT LayerNumber = 0; LayerNumber < LAYER_COUNT; LayerNumber++) {
		for (USHORT x = 0; x < Extension.size(); ++x) {
			_SPARKLET_ASSERT(Extension[x]->GetLayer() < LAYER_COUNT);
			if (Extension[x]->GetLayer() == LayerNumber) {
				Extension[x]->Render(Where, Direction);
			}
		}
	}
}


void CliObject::SetMsg(const AspectInfo *AI) {
	if (AI->Visible)
		BaseSprite->Play();
		//BaseSprite->PlayOnce(); //funky
	else
		BaseSprite->Stop();
}


void CliObject::OnUpdate() {
	NextFrame();
}


void CliObject::NextFrame() {
	for (USHORT x = 0; x < Extension.size(); ++x) {
		if (Extension[x]->NeedsUpdate(gTimeElapsed)) {
			ImageChanged = true;
			Extension[x]->Update();
		}
	}
}


void CliObject::ResetExtensions() {
	for (USHORT x = 0; x < Extension.size(); ++x)
		Extension[x]->Reset();
}


#endif //SERVER_ONLY
