/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#include <allegro.h>
#ifdef _WIN32
	#include <winalleg.h>
#endif

#include "cli_mobile_object.h"
#include "network_messages.h"


extern float gTimeElapsed;


CliMobileObject::CliMobileObject(const TiXmlElement *Root, const Size &Dim, float) :
	CliObject(Root, Dim),
	Velocity(0, 0) {
}


void CliMobileObject::SetMsg(const VelocityInfo *VI) {
	Velocity = VI->Velocity;
	Geo = VI->Loc;
}


void CliMobileObject::OnUpdate() {
	//calculate position
	Geo += Velocity * gTimeElapsed;

	CliObject::OnUpdate();
}


Point<float> CliMobileObject::GetRenderLoc() const {
	return Point<float>(Geo.x - CameraGeo->x + CameraGeo->Width / 2,
		Geo.y - CameraGeo->y + CameraGeo->Height / 2);
}


#endif //SERVER_ONLY
