/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#include "statical_sprite.h"
#include "network_messages.h"
#include "cli_bullet.h"
#include "sparklet_utils.h"


#define VELOCITY_MODIFIER_STR std::string("velocity_modifier")
#define MOTION_TYPE_STR std::string("motion_type")
#define ABS_MAX_STR std::string("abs_max")
#define ROT_PER_SEC_STR std::string("rot_per_sec")

extern float gTimeElapsed;


CliBullet::CliBullet(const TiXmlElement *Root, const Size &Dim, float Scale) :
	CliMobileObject(Root, Dim, Scale),
	VelocityModifierAng(0),
	InitialAngle(0) {

	const TiXmlElementList* Nl = XMLParser::GetAllChildren(Root, VELOCITY_MODIFIER_STR);
	if (Nl->size() == 1) {
		const TiXmlElement *El = Nl->at(0);
		MotionType = XMLParser::GetValueS(El, MOTION_TYPE_STR, "");
		VelocityModifierAbsMax = XMLParser::GetValueF(El, ABS_MAX_STR, 0.f);
		VelocityModifierRotPerSec = XMLParser::GetValueF(El, ROT_PER_SEC_STR, 0.f);
	}
	delete Nl;
}


void CliBullet::SetMsg(const VelocityInfo *VI) {
	CliObject::GetBaseBitmap()->SetDirection(arg(VI->Velocity));
	InitialAngle = arg(VI->Velocity);

	CliMobileObject::SetMsg(VI);
}


void CliBullet::OnUpdate() {
	if (!MotionType.empty()) {
		//apply motion type to the Velocity vector
		if (MotionType == "sinusoidal") {
			//undo last Velocity modification
			Velocity -= polar<float>(sinf(VelocityModifierAng) * VelocityModifierAbsMax, InitialAngle + M_PI / 2.f);
			VelocityModifierAng += gTimeElapsed * (M_PI * 2.f * VelocityModifierRotPerSec);
			Velocity += polar<float>(sinf(BoundAngle(VelocityModifierAng)) * VelocityModifierAbsMax, InitialAngle + M_PI / 2.f);
		}
	}

	CliMobileObject::OnUpdate();
}


#endif //SERVER_ONLY
