/***************************************************************************
 *   Copyright (C) 2003 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef BULLET_H
#define BULLET_H

#include "projectile.h"

#define BULLET_STR std::string("bullet")


class StaticalSprite;


/* Bullet - implements the projectile type that is not affected by media viscosity
	- does adapt its angle to the motion direction
*/
class Bullet : public Projectile {
public:
	Bullet(const TiXmlElement* Att, float Scale = 1.f);

	virtual void OnUpdate();
	virtual void CheckData();
	virtual void GetChangedData(MessageCoder &MC) const;
	virtual void GetCompleteData(MessageCoder &MC) const;

	static const ULONG ID;
	const ULONG GetTypeID() const {return ID;}

	virtual void SetImpulse(const Vector<float> New) {InitialAngle = arg(New); Projectile::SetImpulse(New);}

private:
	StaticalSprite *BaseBitmap;

	std::string MotionType;
	float VelocityModifierAbsMax;
	float VelocityModifierRotPerSec;
	float VelocityModifierAng;

	float InitialAngle;

	bool Bouncer;
	int BounceCount;
	int BounceMax;

	virtual void Damage(const PhysicalObject *Obj);
};



#endif
