/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef BOUINCING_H
#define BOUINCING_H


#include "initializer.h"
#include "round_object.h"
#include "non-rotated_object.h"


#define BOUNCING_STR std::string("bouncing")

class Sprite;
class Sound;


/* Bouncing - implements the object that acts as decor to the map, bouncing around, can explode
*/
class Bouncing : public RoundObject, public NonRotatedObject {
public:
	Bouncing(const TiXmlElement* Att, float Scale = 1.f);
	~Bouncing();

	virtual void OnUpdate();
	virtual void CheckData();
	virtual void GetChangedData(MessageCoder &MC) const;
	virtual void GetCompleteData(MessageCoder &MC) const;

	const ULONG GetTypeID() const {return GEN_ID('b', 'n', 'c', 'g');}

private:
	float Strength;
	Sprite *BaseSprite;
	Sprite *Explosion;
	const Sound *ExplosionSound;

	enum STAGE {STAGE_NORMAL, STAGE_EXPLODING};
	STAGE Stage;
	STAGE OldStage;

	bool CanExplode;
	bool RndStartFrame;

	float OldSpriteFPS;

	bool DataChanged;

	USHORT ParticleCount;
	long RndExplosionImpulse;
	long ExplosionImpulse;
	const TiXmlElement *DOMParticle;

	void Explode();
	virtual void Damage(const PhysicalObject *Obj);
};

DECLARE_FACTORY(Bouncing, Object)

#endif
